/*
 * Decompiled with CFR 0.152.
 */
package its_meow.quickteleports;

import its_meow.quickteleports.command.CommandTpAccept;
import its_meow.quickteleports.command.CommandTpHere;
import its_meow.quickteleports.command.CommandTpa;
import its_meow.quickteleports.util.Teleport;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod(modid="quickteleports", name="Quick Teleports", version="1.1.0", acceptedMinecraftVersions="[1.12,1.13)", acceptableRemoteVersions="*")
@Mod.EventBusSubscriber(modid="quickteleports")
public class QuickTeleportsMod {
    @Mod.Instance(value="quickteleports")
    public static QuickTeleportsMod mod;
    public static HashMap<Teleport, Integer> tps;

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandTpAccept());
        event.registerServerCommand((ICommand)new CommandTpa());
        event.registerServerCommand((ICommand)new CommandTpHere());
    }

    @Nullable
    public static Teleport getSubjectTP(String name) {
        for (Teleport pair : tps.keySet()) {
            if (!pair.getSubject().equals(name)) continue;
            return pair;
        }
        return null;
    }

    @Nullable
    public static Teleport getRequestTP(String name) {
        for (Teleport pair : tps.keySet()) {
            if (!pair.getRequester().equals(name)) continue;
            return pair;
        }
        return null;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        HashSet<Teleport> toRemove = new HashSet<Teleport>();
        for (Teleport tp : tps.keySet()) {
            int time = tps.get(tp);
            if (time > 0) {
                tps.put(tp, --time);
                continue;
            }
            if (time > 0) continue;
            toRemove.add(tp);
            QuickTeleportsMod.notifyTimeoutTP(tp);
        }
        for (Teleport remove : toRemove) {
            tps.remove(remove);
        }
    }

    public static void notifyTimeoutTP(Teleport tp) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        EntityPlayerMP tper = server.func_184103_al().func_152612_a(tp.getRequester());
        EntityPlayerMP target = server.func_184103_al().func_152612_a(tp.getSubject());
        if (target != null) {
            target.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Teleport request from " + TextFormatting.GREEN + tp.getRequester() + TextFormatting.GOLD + " timed out."));
        }
        if (tper != null) {
            tper.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Your request to " + TextFormatting.GREEN + tp.getSubject() + TextFormatting.GOLD + " has timed out after not being accepted."));
        }
    }

    public static void notifyCanceledTP(Teleport tp) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        EntityPlayerMP tper = server.func_184103_al().func_152612_a(tp.getRequester());
        EntityPlayerMP target = server.func_184103_al().func_152612_a(tp.getSubject());
        if (target != null) {
            target.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Teleport request from " + TextFormatting.GREEN + tp.getRequester() + TextFormatting.GOLD + " has been cancelled."));
        }
        if (tper != null) {
            tper.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Your request to " + TextFormatting.GREEN + tp.getSubject() + TextFormatting.GOLD + " has been cancelled."));
        }
    }

    static {
        tps = new HashMap();
    }
}

