/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.core.transformer;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public abstract class ClassNodeTransformer
implements IClassTransformer {
    protected String className;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals(this.className)) {
            System.out.println("Transforming class " + transformedName);
            boolean isObfuscated = !name.equals(transformedName);
            return this.transform(basicClass, isObfuscated);
        }
        return basicClass;
    }

    private byte[] transform(byte[] basicClass, boolean isObfuscated) {
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        this.transformNode(classNode, isObfuscated);
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    protected abstract void transformNode(ClassNode var1, boolean var2);
}

