/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.world.biomes;

import java.util.Random;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import prospector.traverse.config.TraverseConfig;
import prospector.traverse.world.WorldGenConstants;
import prospector.traverse.world.features.WorldGenPatch;

public class BiomeRockyPlains
extends BiomePlains
implements WorldGenConstants {
    protected static final WorldGenPatch STONE_PATCH_FEATURE = new WorldGenPatch(Blocks.field_150348_b.func_176223_P(), 5);
    protected static final WorldGenBlockBlob COBBLESTONE_BOULDER_FEATURE = new WorldGenBlockBlob(Blocks.field_150347_e, 1);
    public static Biome.BiomeProperties properties = new Biome.BiomeProperties("Rocky Plains");

    public BiomeRockyPlains() {
        super(false, properties);
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityHorse.class, 4, 1, 5));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityDonkey.class, 1, 1, 2));
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        BlockPos blockpos;
        int k6;
        int genChance;
        int stoneChance = rand.nextInt(4);
        if (stoneChance == 0) {
            int k62 = rand.nextInt(16) + 8;
            int l = rand.nextInt(16) + 8;
            BlockPos blockpos2 = worldIn.func_175645_m(pos.func_177982_a(k62, 0, l));
            STONE_PATCH_FEATURE.func_180709_b(worldIn, rand, blockpos2);
        }
        if (!TraverseConfig.disallowBoulders && TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.ROCK) && (genChance = rand.nextInt(4)) == 0) {
            k6 = rand.nextInt(16) + 8;
            int l = rand.nextInt(16) + 8;
            blockpos = worldIn.func_175645_m(pos.func_177982_a(k6, 0, l));
            COBBLESTONE_BOULDER_FEATURE.func_180709_b(worldIn, rand, blockpos);
        }
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE) && (genChance = rand.nextInt(3)) == 0) {
            k6 = rand.nextInt(16) + 8;
            int l = rand.nextInt(16) + 8;
            blockpos = worldIn.func_175645_m(pos.func_177982_a(k6, 0, l));
            OAK_SHRUB_FEATURE.func_180709_b(worldIn, rand, blockpos);
        }
        super.func_180624_a(worldIn, rand, pos);
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        if (noiseVal > 1.6) {
            this.field_76752_A = Blocks.field_150348_b.func_176223_P();
            this.field_76753_B = Blocks.field_150348_b.func_176223_P();
        } else {
            this.field_76752_A = Blocks.field_150349_c.func_176223_P();
            this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        }
        this.func_180628_b(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public BiomeDecorator func_76729_a() {
        return super.func_76729_a();
    }

    static {
        properties.func_185410_a(0.9f);
        properties.func_185395_b(0.7f);
        properties.func_185398_c(0.125f);
        properties.func_185400_d(0.15f);
    }

    public class DecoratorRockyPlains
    extends BiomeDecorator {
        public DecoratorRockyPlains() {
            this.field_76832_z = 0;
            this.field_189870_A = 0.15f;
            this.field_76802_A = 4;
            this.field_76803_B = 10;
        }

        protected void func_76795_a(World worldIn, Random random, int blockCount, WorldGenerator generator, int minHeight, int maxHeight) {
            super.func_76795_a(worldIn, random, blockCount, generator, minHeight, maxHeight);
        }

        protected void func_76793_b(World worldIn, Random random, int blockCount, WorldGenerator generator, int centerHeight, int spread) {
            for (int i = 0; i < blockCount; ++i) {
                BlockPos blockpos = this.field_180294_c.func_177982_a(random.nextInt(16), random.nextInt(spread) + random.nextInt(spread) + centerHeight - spread, random.nextInt(16));
                generator.func_180709_b(worldIn, random, blockpos);
            }
        }
    }
}

