/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionFileCache;
import xaero.map.MapProcessor;
import xaero.map.Misc;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class WorldDataReader {
    private boolean[] underair;
    private boolean[] blockFound;
    private byte[] lightLevels;
    private int[] biomeBuffer;
    private MapBlock buildingObject = new MapBlock();
    private OverlayBuilder[] overlayBuilders;
    private IBlockState[] prevOverlays;
    private boolean[] overlayNeedsBiome;
    private BlockPos.MutableBlockPos mutableBlockPos;

    public WorldDataReader(OverlayManager overlayManager) {
        this.underair = new boolean[256];
        this.blockFound = new boolean[256];
        this.lightLevels = new byte[256];
        this.biomeBuffer = new int[3];
        this.prevOverlays = new IBlockState[256];
        this.overlayNeedsBiome = new boolean[256];
        this.overlayBuilders = new OverlayBuilder[256];
        this.mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < this.overlayBuilders.length; ++i) {
            this.overlayBuilders[i] = new OverlayBuilder(overlayManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildRegion(MapRegion region, File worldDir, World world, boolean loading, int[] chunkCountDest) {
        boolean regionIsResting;
        if (!loading) {
            region.pushWriterPause();
        }
        boolean result = true;
        int prevRegX = region.getRegionX();
        int prevRegZ = region.getRegionZ() - 1;
        MapRegion prevRegion = MapProcessor.instance.getMapRegion(prevRegX, prevRegZ, false);
        MapRegion mapRegion = region;
        synchronized (mapRegion) {
            regionIsResting = region.isResting();
            if (!loading && regionIsResting) {
                region.setBeingWritten(true);
                region.setShouldCache(false, "world save");
                region.setReloadHasBeenRequested(false, "world save");
                region.setVersion(MapProcessor.instance.getGlobalVersion());
                if (region.getLoadState() != 2) {
                    if (region.getLoadState() == 4) {
                        region.restoreBufferUpdateObjects();
                    }
                    region.setLoadState((byte)2);
                    region.setLastSaveTime(System.currentTimeMillis() + 100000L);
                    MapProcessor.instance.addToProcess(region);
                } else {
                    MapProcessor.instance.removeToRefresh(region);
                    region.setRefreshing(false);
                }
            }
        }
        int caveStart = MapProcessor.instance.getCaveStart();
        if (loading || region.getLoadState() == 2 && regionIsResting) {
            RegionFile regionFile = RegionFileCache.func_76550_a((File)worldDir, (int)(region.getRegionX() * 32), (int)(region.getRegionZ() * 32));
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    MapTileChunk tileChunk = region.getChunk(i, j);
                    if (tileChunk == null) {
                        tileChunk = new MapTileChunk(region, (region.getRegionX() << 3) + i, (region.getRegionZ() << 3) + j);
                        region.setChunk(i, j, tileChunk);
                    }
                    this.buildTileChunk(tileChunk, caveStart, prevRegion, regionFile, world);
                    tileChunk.setLoadState((byte)2);
                    if (!tileChunk.includeInSave()) {
                        tileChunk = null;
                        region.setChunk(i, j, null);
                        continue;
                    }
                    chunkCountDest[0] = chunkCountDest[0] + 1;
                }
            }
            if (region.isMultiplayer()) {
                region.setLastSaveTime(System.currentTimeMillis() - 60000L + 1500L);
            }
        } else {
            result = false;
        }
        if (!loading) {
            region.popWriterPause();
        }
        return result;
    }

    private void buildTileChunk(MapTileChunk tileChunk, int caveStart, MapRegion prevRegion, RegionFile regionFile, World world) {
        tileChunk.unincludeInSave();
        tileChunk.resetMasks();
        for (int insideX = 0; insideX < 4; ++insideX) {
            for (int insideZ = 0; insideZ < 4; ++insideZ) {
                NBTTagCompound nbttagcompound;
                int chunkZ;
                MapTile tile = tileChunk.getTile(insideX, insideZ);
                int chunkX = (tileChunk.getX() << 2) + insideX;
                DataInputStream datainputstream = regionFile.func_76704_a(chunkX & 0x1F, (chunkZ = (tileChunk.getZ() << 2) + insideZ) & 0x1F);
                if (datainputstream == null) {
                    if (tile == null) continue;
                    tileChunk.setChanged(true);
                    tileChunk.setTile(insideX, insideZ, null);
                    MapProcessor.instance.getTilePool().addToPool(tile);
                    continue;
                }
                boolean createdTile = false;
                if (tile == null) {
                    tile = MapProcessor.instance.getTilePool().get(MapProcessor.instance.getCurrentDimension(), chunkX, chunkZ);
                    createdTile = true;
                }
                if (tile.getPrevTile() == null) {
                    tileChunk.findPrevTile(prevRegion, tile, insideX, insideZ);
                }
                try {
                    nbttagcompound = CompressedStreamTools.func_74794_a((DataInputStream)datainputstream);
                    datainputstream.close();
                }
                catch (IOException e) {
                    try {
                        datainputstream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    System.out.println(String.format("Error loading chunk nbt for chunk %d %d!", chunkX, chunkZ));
                    e.printStackTrace();
                    if (tile == null) continue;
                    tileChunk.setTile(insideX, insideZ, null);
                    MapProcessor.instance.getTilePool().addToPool(tile);
                    continue;
                }
                nbttagcompound = Minecraft.func_71410_x().func_184126_aj().func_188257_a((IFixType)FixTypes.CHUNK, nbttagcompound);
                if (this.buildTile(nbttagcompound, tile, tileChunk, chunkX, chunkZ, caveStart, world)) {
                    tileChunk.setTile(insideX, insideZ, tile);
                    if (!createdTile) continue;
                    tileChunk.setChanged(true);
                    continue;
                }
                tileChunk.setTile(insideX, insideZ, null);
                MapProcessor.instance.getTilePool().addToPool(tile);
            }
        }
        if (tileChunk.wasChanged()) {
            tileChunk.updateBuffers(world);
            tileChunk.setChanged(false);
        }
    }

    private boolean buildTile(NBTTagCompound nbttagcompound, MapTile tile, MapTileChunk tileChunk, int chunkX, int chunkZ, int caveStart, World world) {
        NBTTagCompound levelCompound = nbttagcompound.func_74775_l("Level");
        if (levelCompound.func_74771_c("LightPopulated") == 0 || levelCompound.func_74771_c("TerrainPopulated") == 0) {
            return false;
        }
        int fillCounter = 256;
        for (int i = 0; i < this.blockFound.length; ++i) {
            this.overlayBuilders[i].startBuilding();
            this.overlayNeedsBiome[i] = false;
            this.blockFound[i] = false;
            this.underair[i] = false;
            this.prevOverlays[i] = null;
        }
        int[] heightMap = levelCompound.func_74759_k("HeightMap");
        boolean heightMapExists = heightMap.length == 256;
        byte[] biomes = null;
        int[] biomesInt = null;
        boolean biomesDataExists = false;
        if (levelCompound.func_150297_b("Biomes", 7)) {
            biomes = levelCompound.func_74770_j("Biomes");
            biomesDataExists = biomes.length == 256;
        } else if (levelCompound.func_150297_b("Biomes", 11)) {
            biomesInt = levelCompound.func_74759_k("Biomes");
            biomesDataExists = biomesInt.length == 256;
        }
        boolean cave = caveStart != -1;
        NBTTagList sectionsList = levelCompound.func_150295_c("Sections", 10);
        if (sectionsList.func_74745_c() == 0) {
            return false;
        }
        for (int i = sectionsList.func_74745_c() - 1; i >= 0 && fillCounter > 0; --i) {
            NBTTagCompound sectionCompound = sectionsList.func_150305_b(i);
            boolean hasBlocks = sectionCompound.func_150297_b("Blocks", 7);
            boolean hasPalette = sectionCompound.func_150297_b("Palette", 11);
            byte[] blockIds_a = null;
            byte[] dataArray = null;
            byte[] addArray = null;
            byte[] add2Array = null;
            int[] palette = null;
            if (hasBlocks) {
                blockIds_a = sectionCompound.func_74770_j("Blocks");
                addArray = sectionCompound.func_150297_b("Add", 7) ? sectionCompound.func_74770_j("Add") : null;
                add2Array = sectionCompound.func_150297_b("Add2", 7) ? sectionCompound.func_74770_j("Add2") : null;
                dataArray = sectionCompound.func_74770_j("Data");
            }
            if (hasPalette) {
                palette = sectionCompound.func_74759_k("Palette");
            }
            byte[] lightMap = null;
            if (sectionCompound.func_150297_b("BlockLight", 7) && (lightMap = sectionCompound.func_74770_j("BlockLight")).length != 2048) {
                lightMap = null;
            }
            int sectionHeight = sectionCompound.func_74771_c("Y") * 16;
            for (int z = 0; z < 16; ++z) {
                block3: for (int x = 0; x < 16; ++x) {
                    int pos_2d = (z << 4) + x;
                    if (this.blockFound[pos_2d]) continue;
                    int height = heightMapExists ? heightMap[pos_2d] : 256;
                    int startHeight = height + 3;
                    if (cave) {
                        startHeight = caveStart;
                    }
                    if (i > 0 && startHeight < sectionHeight) continue;
                    int biome = biomesDataExists ? (biomesInt != null ? biomesInt[pos_2d] : biomes[pos_2d] & 0xFF) : 0;
                    int localStartHeight = 15;
                    if (!cave) {
                        this.underair[pos_2d] = true;
                    }
                    if (startHeight >> 4 << 4 == sectionHeight) {
                        localStartHeight = startHeight & 0xF;
                    }
                    for (int y = localStartHeight; y >= 0; --y) {
                        int h = sectionHeight + y;
                        int pos = y << 8 | pos_2d;
                        int blockId = 0;
                        int blockMeta = 0;
                        if (hasPalette) {
                            int leftIndexPart = hasBlocks ? (blockIds_a[pos] & 0xFF) << 4 : 0;
                            int paletteIndex = leftIndexPart | this.nibbleValue(dataArray, pos);
                            int blockStateOtherId = palette[paletteIndex];
                            blockId = blockStateOtherId >> 4;
                            blockMeta = blockStateOtherId & 0xF;
                        } else if (hasBlocks) {
                            blockId = blockIds_a[pos] & 0xFF | (addArray == null ? 0 : this.nibbleValue(addArray, pos) << 8);
                            if (add2Array != null) {
                                blockId |= this.nibbleValue(add2Array, pos) << 12;
                            }
                            blockMeta = this.nibbleValue(dataArray, pos);
                        }
                        int stateId = Block.func_176210_f((IBlockState)Block.func_149729_e((int)blockId).func_176203_a(blockMeta));
                        this.mutableBlockPos.func_181079_c(chunkX << 4 | x, sectionHeight | y, chunkZ << 4 | z);
                        boolean buildResult = this.buildPixel(this.buildingObject, stateId, x, h, z, pos_2d, this.biomeBuffer, this.lightLevels[pos_2d], biome, cave, this.overlayBuilders[pos_2d], world, this.mutableBlockPos);
                        if (!buildResult && y == 0 && i == 0) {
                            this.buildingObject.prepareForWriting();
                            buildResult = true;
                        }
                        if (buildResult) {
                            MapBlock currentPixel = tile.getBlock(x, z);
                            if (!this.buildingObject.equals(currentPixel)) {
                                tile.setBlock(x, z, this.buildingObject);
                                this.buildingObject = currentPixel != null ? currentPixel : new MapBlock();
                                tileChunk.setChanged(true);
                            }
                            this.blockFound[pos_2d] = true;
                            --fillCounter;
                            continue block3;
                        }
                        this.lightLevels[pos_2d] = lightMap == null ? (byte)0 : this.nibbleValue(lightMap, pos);
                    }
                }
            }
        }
        tile.setWrittenOnce(true);
        tile.setLoaded(true);
        return true;
    }

    private boolean buildPixel(MapBlock pixel, int stateId, int x, int h, int z, int pos_2d, int[] biomeBuffer, byte light, int biome, boolean cave, OverlayBuilder overlayBuilder, World world, BlockPos.MutableBlockPos mutableBlockPos) {
        IBlockState state = Misc.getStateById(stateId);
        Block b = state.func_177230_c();
        if (b instanceof BlockAir) {
            this.underair[pos_2d] = true;
            return false;
        }
        if (!this.underair[pos_2d]) {
            return false;
        }
        int lightOpacity = state.getLightOpacity((IBlockAccess)world, (BlockPos)mutableBlockPos);
        if (MapProcessor.instance.getMapWriter().shouldOverlay(state, b, lightOpacity)) {
            if (state != this.prevOverlays[pos_2d]) {
                this.getOverlayBiomeColour(world, state, b, (BlockPos)mutableBlockPos, biomeBuffer);
                this.prevOverlays[pos_2d] = state;
                if (biomeBuffer[1] == 1) {
                    this.overlayNeedsBiome[pos_2d] = true;
                }
            }
            overlayBuilder.build(stateId, biomeBuffer, lightOpacity, light, world);
            return false;
        }
        if (MapProcessor.instance.getMapWriter().isInvisible(world, state, b)) {
            return false;
        }
        pixel.prepareForWriting();
        overlayBuilder.finishBuilding(pixel);
        MapProcessor.instance.getMapWriter().getBlockBiomeColour(world, null, state, (BlockPos)mutableBlockPos, biomeBuffer, biome);
        if (this.overlayNeedsBiome[pos_2d]) {
            biomeBuffer[1] = biome;
        }
        boolean glowing = MapProcessor.instance.getMapWriter().isGlowing(state);
        pixel.write(stateId, h, biomeBuffer, light, glowing, cave);
        return true;
    }

    public void getOverlayBiomeColour(World world, IBlockState state, Block b, BlockPos pos, int[] dest) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) {
            dest[0] = 1;
            dest[1] = 1;
        } else {
            int customColour = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)world, pos, 0);
            if (customColour != 0xFFFFFF && customColour != -1) {
                dest[0] = 2;
                dest[2] = customColour;
            }
        }
    }

    private byte nibbleValue(byte[] array, int index) {
        byte b = array[index >> 1];
        if ((index & 1) == 0) {
            return (byte)(b & 0xF);
        }
        return (byte)(b >> 4 & 0xF);
    }
}

