/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.api.spigot.ServerWaypointStorage;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModSettings;
import xaero.map.WorldMap;
import xaero.map.mods.SupportBetterPVP;
import xaero.map.mods.SupportMinimap;
import xaero.map.mods.gui.Waypoint;

public class SupportXaeroMinimap {
    IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;
    private boolean deathpoints = true;
    private boolean refreshWaypoints = true;
    private WaypointWorld waypointWorld;
    private WaypointSet waypointSet;
    private ArrayList<Waypoint> waypoints;

    public SupportXaeroMinimap() {
        try {
            this.modMain = SupportBetterPVP.getMain();
            System.out.println("Xaero's WorldMap Mod: Better PVP found!");
        }
        catch (NoClassDefFoundError e) {
            try {
                this.modMain = SupportMinimap.getMain();
                System.out.println("Xaero's WorldMap Mod: Xaero's minimap found!");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (this.modMain != null) {
            this.waypointsManager = this.modMain.getWaypointsManager();
        }
    }

    public boolean waypointIsGood(Waypoint w) {
        return w != null && !w.isDisabled() && (w.getType() != 1 || this.deathpoints);
    }

    public ArrayList<Waypoint> convertWaypoints() {
        ArrayList<Waypoint> result = new ArrayList<Waypoint>();
        if (this.waypointsManager.getWaypoints() == null) {
            return null;
        }
        this.waypointSet = this.waypointsManager.getWaypoints();
        this.waypointWorld = this.waypointsManager.getCurrentWorld();
        ArrayList list = this.waypointsManager.getWaypoints().getList();
        for (int i = 0; i < list.size(); ++i) {
            xaero.common.minimap.waypoints.Waypoint w = (xaero.common.minimap.waypoints.Waypoint)list.get(i);
            result.add(this.convertWaypoint(w, true));
        }
        if (ServerWaypointStorage.working() && this.waypointsManager.getServerWaypoints() != null) {
            for (xaero.common.minimap.waypoints.Waypoint w : this.waypointsManager.getServerWaypoints()) {
                result.add(this.convertWaypoint(w, false));
            }
        }
        this.deathpoints = this.modMain.getSettings().getDeathpoints();
        return result;
    }

    public Waypoint convertWaypoint(xaero.common.minimap.waypoints.Waypoint w, boolean editable) {
        Waypoint converted = new Waypoint(w, w.getX(), w.getY(), w.getZ(), w.getName(), w.getSymbol(), ModSettings.COLORS[w.getColor()], w.getType(), editable);
        converted.setDisabled(w.isDisabled());
        converted.setYaw(w.getYaw());
        converted.setRotation(w.isRotation());
        return converted;
    }

    public void openWaypoint(GuiScreen parent, Waypoint waypoint) {
        if (!waypoint.isEditable()) {
            return;
        }
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAddWaypoint(this.modMain, parent, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld));
    }

    public void createWaypoint(GuiScreen parent, int x, int y, int z) {
        boolean divideBy8 = this.waypointsManager.divideBy8(this.waypointWorld.getContainer().getKey());
        xaero.common.minimap.waypoints.Waypoint w = new xaero.common.minimap.waypoints.Waypoint(x * (divideBy8 ? 8 : 1), y, z * (divideBy8 ? 8 : 1), "", "", -1);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAddWaypoint(this.modMain, parent, w, this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld));
    }

    public void createTempWaypoint(int x, int y, int z) {
        this.waypointsManager.createTemporaryWaypoints(x, y, z);
        this.requestWaypointsRefresh();
    }

    public boolean canTeleport() {
        return this.waypointsManager.canTeleport(this.waypointsManager.isWorldTeleportable(this.waypointWorld), this.waypointWorld);
    }

    public void teleportToWaypoint(GuiScreen screen, Waypoint w) {
        this.waypointsManager.teleportToWaypoint((xaero.common.minimap.waypoints.Waypoint)w.getOriginal(), this.waypointWorld, screen);
    }

    public void disableWaypoint(Waypoint waypoint) {
        ((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).setDisabled(!((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        waypoint.setDisabled(!waypoint.isDisabled());
    }

    public void deleteWaypoint(Waypoint waypoint) {
        this.waypointSet.getList().remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal());
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.waypoints.remove(waypoint);
    }

    public boolean isOnScreen(Waypoint w, double cameraX, double cameraZ, int width, int height, double scale) {
        double xOnScreen = ((double)w.getX() - cameraX) * scale + (double)(width / 2);
        double zOnScreen = ((double)w.getZ() - cameraZ) * scale + (double)(height / 2);
        return xOnScreen < (double)width && xOnScreen > 0.0 && zOnScreen < (double)height && zOnScreen > 0.0;
    }

    public ArrayList<Waypoint> renderWaypoints(GuiScreen gui, double cameraX, double cameraZ, int width, int height, double guiScale, double scale, double mouseX, double mouseZ, Pattern regex, Pattern regexStartsWith) {
        if (this.refreshWaypoints || this.waypointSet != this.waypointsManager.getWaypoints()) {
            this.waypoints = this.convertWaypoints();
            this.refreshWaypoints = false;
            if (this.waypoints != null) {
                Collections.sort(this.waypoints);
            }
        }
        if (this.waypoints == null) {
            return null;
        }
        Waypoint viewed = null;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        for (int i = this.waypoints.size() - 1; i >= 0; --i) {
            Waypoint w = this.waypoints.get(i);
            if (!this.waypointIsGood(w) || !((double)w.getZ() > mouseZ) || !((double)w.getZ() - 41.0 / scale < mouseZ)) continue;
            double d = Math.abs((double)w.getX() - mouseX);
            float f = w.getSymbol().length() > 1 ? 20.5f : 14.0f;
            if (!(d <= (double)f / scale)) continue;
            viewed = w;
            break;
        }
        ArrayList<Waypoint> outsideWaypoints = new ArrayList<Waypoint>();
        for (Waypoint w : this.waypoints) {
            if (!this.waypointIsGood(w)) continue;
            if (this.isOnScreen(w, cameraX, cameraZ, width, height, scale)) {
                w.renderShadow(gui, guiScale, scale, w.getX(), w.getZ());
                continue;
            }
            if (regex == null) {
                outsideWaypoints.add(w);
                continue;
            }
            if (regexStartsWith.matcher(w.getName().toLowerCase()).find()) {
                outsideWaypoints.add(0, w);
                continue;
            }
            if (!regex.matcher(w.getName().toLowerCase()).find()) continue;
            outsideWaypoints.add(w);
        }
        for (Waypoint w : this.waypoints) {
            if (!this.waypointIsGood(w) || w == viewed || !this.isOnScreen(w, cameraX, cameraZ, width, height, scale)) continue;
            w.renderWaypoint(gui, guiScale, scale, w.getX(), w.getZ(), false);
        }
        if (viewed != null) {
            viewed.renderWaypoint(gui, guiScale, scale, viewed.getX(), viewed.getZ(), true);
        }
        outsideWaypoints.add(0, viewed);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        return outsideWaypoints;
    }

    public void renderSideWaypoints(GuiScreen gui, ArrayList<Waypoint> sideWaypoints, double scale, int width, int height, int offset, int selected) {
        int yPos = height - 2;
        if (offset > 0) {
            yPos = this.drawThreeDots(yPos, width);
        }
        for (int i = offset; i < sideWaypoints.size(); ++i) {
            float wpScale = i == selected ? 1.5f : 1.0f;
            yPos = (int)((float)yPos - 5.0f * wpScale);
            sideWaypoints.get(i).renderSideWaypoint(gui, (float)(width - 2) - 5.0f * wpScale, yPos, wpScale);
            yPos = (int)((float)yPos - (1.0f + 4.0f * wpScale));
            if (i + 1 >= sideWaypoints.size() || i - offset != 6) continue;
            yPos = this.drawThreeDots(yPos, width);
            break;
        }
    }

    private int drawThreeDots(int yPos, int width) {
        Minecraft.func_71410_x().field_71466_p.func_175065_a("...", (float)(width - 7 - Minecraft.func_71410_x().field_71466_p.func_78256_a("...") / 2), (float)((yPos -= 9) - 4), Waypoint.white, true);
        return yPos -= 5;
    }

    public void requestWaypointsRefresh() {
        this.refreshWaypoints = true;
    }

    public int getWaypointKeyCode() {
        return ModSettings.newWaypoint.func_151463_i();
    }

    public int getTempWaypointKeyCode() {
        return ModSettings.keyInstantWaypoint.func_151463_i();
    }
}

