/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;

public class Waypoint
implements Comparable<Waypoint> {
    private Object original;
    public static final ResourceLocation minimapTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
    public static final int white = new Color(255, 255, 255, 255).hashCode();
    private int x;
    private int y;
    private int z;
    private String text;
    private String symbol;
    private int color;
    private boolean disabled = false;
    private int type = 0;
    private boolean rotation = false;
    private int yaw = 0;
    private float destAlpha = 0.0f;
    private float alpha = 0.0f;
    private SlowingAnimation alphaAnim = null;
    private boolean editable;

    public Waypoint(Object original, int x, int y, int z, String name, String symbol, int color, int type, boolean editable) {
        this.original = original;
        this.x = x;
        this.y = y;
        this.z = z;
        this.symbol = symbol;
        this.color = color;
        this.type = type;
        this.text = name;
        this.editable = editable;
    }

    public String getName() {
        return I18n.func_135052_a((String)this.text, (Object[])new Object[0]);
    }

    public void renderWaypoint(GuiScreen gui, double guiScale, double scale, float x, float y, boolean viewing) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(WorldMap.guiTextures);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179139_a((double)(1.0 / scale), (double)(1.0 / scale), (double)1.0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179124_c((float)((float)(this.color >> 16 & 0xFF) / 255.0f), (float)((float)(this.color >> 8 & 0xFF) / 255.0f), (float)((float)(this.color & 0xFF) / 255.0f));
        int flagU = 35;
        int flagV = 34;
        int flagW = 30;
        int flagH = 43;
        if (this.symbol.length() > 1) {
            flagU = 70;
            flagW = 43;
        }
        GlStateManager.func_179109_b((float)((float)(-flagW) / 2.0f), (float)(-flagH + 1), (float)0.0f);
        Gui.func_146110_a((int)0, (int)0, (float)flagU, (float)flagV, (int)flagW, (int)flagH, (float)256.0f, (float)256.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        float oldDestAlpha = this.destAlpha;
        this.destAlpha = viewing ? 255.0f : 0.0f;
        if (oldDestAlpha != this.destAlpha) {
            this.alphaAnim = new SlowingAnimation(this.alpha, this.destAlpha, 0.8, 1.0);
        }
        if (this.alphaAnim != null) {
            this.alpha = (float)this.alphaAnim.getCurrent();
        }
        int symbolTexture = 0;
        int symbolVerticalOffset = 0;
        int symbolWidth = 0;
        int stringWidth = mc.field_71466_p.func_78256_a(this.symbol);
        int symbolFrameWidth = stringWidth / 2 > 4 ? 64 : 32;
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        if (this.type == 0 && this.alpha < 200.0f) {
            symbolVerticalOffset = 5;
            symbolWidth = (stringWidth - 1) * 3;
            symbolTexture = WorldMap.waypointSymbolCreator.getSymbolTexture(this.symbol);
        } else if (this.type == 1) {
            symbolVerticalOffset = 3;
            symbolWidth = 27;
            symbolTexture = WorldMap.waypointSymbolCreator.getDeathSymbolTexture();
        }
        if (symbolTexture != 0) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179144_i((int)symbolTexture);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-1.0f - (float)symbolWidth / 2.0f), (float)(-11 + symbolVerticalOffset - 1), (float)0.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
            Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)symbolFrameWidth, (int)32, (float)symbolFrameWidth, (float)32.0f);
            GlStateManager.func_179121_F();
        }
        if ((int)this.alpha > 0) {
            int r = this.color >> 16 & 0xFF;
            int g = this.color >> 8 & 0xFF;
            int b = this.color & 0xFF;
            int c = (int)this.alpha << 24 | r << 16 | g << 8 | b;
            int tbg = (int)(this.alpha / 255.0f * 200.0f) << 24;
            int tc = (int)this.alpha << 24 | 0xFF0000 | 0xFF00 | 0xFF;
            String name = this.getName();
            int len = mc.field_71466_p.func_78256_a(name);
            GlStateManager.func_179109_b((float)0.0f, (float)-38.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)3.0f, (float)3.0f, (float)1.0f);
            int bgLen = Math.max(len + 2, 10);
            Gui.func_73734_a((int)(-bgLen / 2), (int)-1, (int)(bgLen / 2), (int)9, (int)c);
            Gui.func_73734_a((int)(-bgLen / 2), (int)-1, (int)(bgLen / 2), (int)8, (int)tbg);
            GlStateManager.func_179147_l();
            if ((int)this.alpha > 3) {
                mc.field_71466_p.func_175065_a(name, (float)(-(len - 1)) / 2.0f, 0.0f, tc, false);
            }
        }
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void renderSideWaypoint(GuiScreen gui, float x, float y, float scale) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        GlStateManager.func_179109_b((float)-4.0f, (float)-4.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179124_c((float)((float)(this.color >> 16 & 0xFF) / 255.0f), (float)((float)(this.color >> 8 & 0xFF) / 255.0f), (float)((float)(this.color & 0xFF) / 255.0f));
        if (this.type == 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(minimapTextures);
            gui.func_73729_b(0, 0, 0, 78, 9, 9);
        } else {
            GlStateManager.func_179090_x();
            Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)this.color);
        }
        GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
        if (this.type == 0) {
            mc.field_71466_p.func_175065_a(this.symbol, (float)(5 - mc.field_71466_p.func_78256_a(this.symbol) / 2), 1.0f, white, true);
        }
        String name = this.getName();
        int len = mc.field_71466_p.func_78256_a(name);
        mc.field_71466_p.func_175065_a(name, (float)(-3 - len), 0.0f, white, true);
        GlStateManager.func_179147_l();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void renderShadow(GuiScreen gui, double guiScale, double scale, float x, float y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179139_a((double)(guiScale / 3.0 / scale), (double)(guiScale / 3.0 / scale), (double)1.0);
        GlStateManager.func_179109_b((float)-14.0f, (float)-41.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)MapProcessor.instance.getBrightness());
        gui.func_73729_b(0, 19, 0, 117, 41, 22);
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public int compareTo(Waypoint arg0) {
        return this.z > arg0.z ? 1 : (this.z != arg0.z ? -1 : 0);
    }

    public String toString() {
        return this.getName();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public int getType() {
        return this.type;
    }

    public int getYaw() {
        return this.yaw;
    }

    public void setYaw(int yaw) {
        this.yaw = yaw;
    }

    public boolean isRotation() {
        return this.rotation;
    }

    public void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public Object getOriginal() {
        return this.original;
    }

    public String getSymbol() {
        return this.symbol;
    }
}

