/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.classic.recipe.machine;

import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;

public interface IElectrolyzerRecipeList {
    public void addBothRecipe(ItemStack var1, ItemStack var2, int var3, String var4);

    public void addChargeRecipe(ItemStack var1, ItemStack var2, int var3, String var4);

    public void addDischargeRecipe(ItemStack var1, ItemStack var2, int var3, String var4);

    public List<RecipeEntry> getRecipeList();

    public void removeRecipe(ItemStack var1, boolean var2, boolean var3);

    public RecipeEntry getOutput(ItemStack var1, boolean var2);

    public static class RecipeEntry {
        ItemStack input;
        ItemStack output;
        int energy;
        boolean both;
        boolean charge;
        int hashCode;

        public RecipeEntry(ItemStack in, ItemStack out, int energy, boolean both, boolean charge) {
            if (in == null || out == null) {
                return;
            }
            this.input = in.func_77946_l();
            this.output = out.func_77946_l();
            this.energy = energy;
            this.both = both;
            this.charge = charge;
            this.hashCode = Objects.hash(in.func_77973_b(), in.func_77960_j(), out.func_77973_b(), out.func_77960_j(), energy, both, charge);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RecipeEntry) {
                RecipeEntry entry = (RecipeEntry)obj;
                if (this.isInputEqual(entry.input) && this.isOutputEqual(entry.output) && this.energy == entry.energy && this.both == entry.both) {
                    if (this.both) {
                        return true;
                    }
                    return this.charge == entry.charge;
                }
            }
            return false;
        }

        public boolean isInputEqual(ItemStack other) {
            if (this.input == null || other == null) {
                return false;
            }
            if (this.input.func_77973_b() != other.func_77973_b()) {
                return false;
            }
            return this.input.func_77960_j() == other.func_77960_j();
        }

        public boolean isOutputEqual(ItemStack other) {
            if (this.output == null || other == null) {
                return false;
            }
            if (this.output.func_77973_b() != other.func_77973_b()) {
                return false;
            }
            return this.output.func_77960_j() == other.func_77960_j();
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public int getEnergy() {
            return this.energy;
        }

        public boolean isDualRecipe() {
            return this.both;
        }

        public boolean isChargeRecipe() {
            return this.charge;
        }
    }
}

