/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric;

import ic2.api.classic.event.RetextureEventClassic;
import ic2.api.classic.item.IElectricTool;
import ic2.api.classic.network.ICustomNetworkItemEventListener;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.base.BasicElectricItem;
import ic2.core.item.render.model.ObscuratorModel;
import ic2.core.network.fieldEvents.item.ObscuratorFieldData;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.IAdvancedTexturedItem;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import ic2.core.platform.textures.obj.ICustomModeledItem;
import ic2.core.platform.textures.obj.IStaticTexturedItem;
import ic2.core.util.helpers.ToolHelper;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricToolObscurator
extends BasicElectricItem
implements IStaticTexturedItem,
IAdvancedTexturedItem,
ICustomModeledItem,
ICustomNetworkItemEventListener,
IElectricTool,
ICustomItemCameraTransform {
    public ModelResourceLocation[] locations = new ModelResourceLocation[2];
    public static final int copyCost = 10000;
    public static final int drawCost = 1500;

    public ItemElectricToolObscurator() {
        this.setUnlocalizedName(Ic2ItemLang.obscurator);
        this.maxCharge = 100000;
        this.tier = 2;
        this.transferLimit = 250;
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 81;
    }

    @Override
    public boolean hasCustomTransform(int meta) {
        return true;
    }

    @Override
    public ResourceLocation getCustomTransform(int meta) {
        return new ResourceLocation("minecraft:models/item/handheld");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation createResourceLocationForStack(ItemStack stack) {
        ModelResourceLocation location;
        String name = this.func_77667_c(stack) + (stack.func_77960_j() == 0 ? "" : "textured");
        this.locations[stack.func_77960_j()] = location = new ModelResourceLocation(this.getRegistryName().func_110624_b() + name.substring(name.indexOf(".") + 1), "inventory");
        return location;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getResourceLocationForStack(ItemStack stack) {
        if (this.hasBlock(stack)) {
            return this.locations[1];
        }
        return this.locations[0];
    }

    @Override
    public List<ItemStack> getValidItemTypes() {
        return Arrays.asList(new ItemStack((Item)this, 1, 1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BaseModel getModelFromItem(ItemStack item) {
        return new ObscuratorModel(Ic2Icons.getTextures("i1")[81], this);
    }

    @Override
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        List<String> ctrlTip = sortedTooltip.get((Object)ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2), Ic2InfoLang.rotateLayer));
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2) + " & " + IC2.keyboard.getKeyName(9), Ic2InfoLang.setLayer));
        ctrlTip.add("");
        ctrlTip.add(Ic2Lang.onBlockClick.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2InfoLang.putTexture.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(0), Ic2InfoLang.putTextureAll));
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(9), Ic2InfoLang.takeTexture));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K && IC2.keyboard.isModeSwitchKeyDown(playerIn)) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            if (playerIn.func_70093_af()) {
                byte[] array = this.getRotations(stack);
                IC2.platform.messagePlayer(playerIn, Ic2InfoLang.layerSwitched, this.increaseLayer(stack, array.length));
            } else {
                byte rotation;
                byte[] rotations = this.getRotations(stack);
                int layer = this.getLayer(stack);
                if (layer >= rotations.length) {
                    layer = rotations.length - 1;
                    this.setLayer(stack, layer);
                }
                if ((rotation = (byte)(rotations[layer] + 1)) >= 4) {
                    rotation = 0;
                }
                rotations[layer] = rotation;
                this.setRotations(stack, rotations);
                IC2.platform.messagePlayer(playerIn, Ic2InfoLang.layerRotated, layer, RetextureEventClassic.Rotation.getRotation(rotation).getRotation());
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (IC2.keyboard.isModeSwitchKeyDown(player)) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (IC2.platform.isRendering() && player.func_70093_af()) {
            if (!ElectricItem.manager.canUse(stack, 10000.0)) {
                return EnumActionResult.FAIL;
            }
            if (world.func_175623_d(pos)) {
                return EnumActionResult.PASS;
            }
            IBlockState state = world.func_180495_p(pos);
            if (state.func_185901_i() != EnumBlockRenderType.MODEL) {
                return EnumActionResult.FAIL;
            }
            IBlockState actualState = state.func_185899_b((IBlockAccess)world, pos);
            if (!this.isStateValid(actualState, state)) {
                return EnumActionResult.FAIL;
            }
            IBlockState extendetState = actualState.func_177230_c().getExtendedState(actualState, (IBlockAccess)world, pos);
            if (!this.isStateValid(extendetState, state)) {
                return EnumActionResult.FAIL;
            }
            if (!this.validateModel(actualState, extendetState, side)) {
                return EnumActionResult.FAIL;
            }
            int[] colors = this.getColorMultiplier(actualState, extendetState, side, world, pos);
            IC2.network.get().initiateCustomClientItemEvent(stack, new ObscuratorFieldData(hand, side, actualState, extendetState, colors));
            return EnumActionResult.SUCCESS;
        }
        if (IC2.platform.isSimulating() && !player.func_70093_af()) {
            if (!this.hasBlock(stack)) {
                return EnumActionResult.PASS;
            }
            if (IC2.keyboard.isAltKeyDown(player)) {
                EnumActionResult result = EnumActionResult.FAIL;
                for (EnumFacing sides : EnumFacing.field_82609_l) {
                    if (!ElectricItem.manager.canUse(stack, 1500.0)) {
                        return result;
                    }
                    Block texBlock = this.getBlock(stack);
                    RetextureEventClassic event = new RetextureEventClassic(world, pos, sides, player, this.getSide(stack), ToolHelper.stringToBlockState(texBlock, this.getModelState(stack)), ToolHelper.stringToBlockState(texBlock, this.getRenderState(stack)), this.getColors(stack), RetextureEventClassic.Rotation.convert(this.getRotations(stack)));
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (!event.isApplied()) continue;
                    IC2.achievements.issueStat(player, "texturesStolen");
                    if (!player.field_71075_bZ.field_75098_d) {
                        ElectricItem.manager.use(stack, 1500.0, (EntityLivingBase)player);
                    }
                    result = EnumActionResult.SUCCESS;
                }
                return result;
            }
            if (!ElectricItem.manager.canUse(stack, 1500.0)) {
                return EnumActionResult.FAIL;
            }
            Block texBlock = this.getBlock(stack);
            RetextureEventClassic event = new RetextureEventClassic(world, pos, side, player, this.getSide(stack), ToolHelper.stringToBlockState(texBlock, this.getModelState(stack)), ToolHelper.stringToBlockState(texBlock, this.getRenderState(stack)), this.getColors(stack), RetextureEventClassic.Rotation.convert(this.getRotations(stack)));
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isApplied()) {
                IC2.achievements.issueStat(player, "texturesStolen");
                if (!player.field_71075_bZ.field_75098_d) {
                    ElectricItem.manager.use(stack, 1500.0, (EntityLivingBase)player);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    private boolean isStateValid(IBlockState key, IBlockState value) {
        return key.func_177230_c() == value.func_177230_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int[] getColorMultiplier(IBlockState modelState, IBlockState renderState, EnumFacing dir, World world, BlockPos pos) {
        List quads = Minecraft.func_71410_x().func_175602_ab().func_184389_a(modelState).func_188616_a(renderState, dir, 0L);
        int[] colorMultipliers = new int[quads.size()];
        BlockColors color = Minecraft.func_71410_x().func_184125_al();
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            colorMultipliers[i] = !quad.func_178212_b() ? -1 : color.func_186724_a(renderState, (IBlockAccess)world, pos, quad.func_178211_c());
        }
        return colorMultipliers;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean validateModel(IBlockState modelState, IBlockState renderState, EnumFacing dir) {
        BlockRendererDispatcher patcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = patcher.func_175023_a().func_178125_b(modelState);
        if (model == patcher.func_175023_a().func_178126_b().func_174951_a()) {
            return false;
        }
        if (model.func_188618_c()) {
            return false;
        }
        List quads = model.func_188616_a(renderState, dir, 0L);
        return !quads.isEmpty() && quads.size() <= 10;
    }

    @Override
    public void onNetworkEvent(ItemStack stack, EntityPlayer player, INetworkFieldData data) {
        if (!(data instanceof ObscuratorFieldData)) {
            return;
        }
        ObscuratorFieldData adding = (ObscuratorFieldData)data;
        if (!adding.isValid()) {
            return;
        }
        ItemStack targetStack = player.func_184586_b(adding.getHand());
        if (!StackUtil.isStackEqual(stack, targetStack)) {
            return;
        }
        if (!this.hasBlock(targetStack)) {
            this.setBlock(targetStack, adding.getBlock());
            this.setModelState(targetStack, ToolHelper.blockStateToString(adding.getModelState()));
            this.setRenderState(targetStack, ToolHelper.blockStateToString(adding.getRenderState()));
            this.setSide(targetStack, adding.getSide());
            this.setColors(targetStack, adding.getColorMultiplier());
            this.setRotations(targetStack, new byte[adding.getColorMultiplier().length]);
            this.resetLayer(targetStack);
            if (!player.field_71075_bZ.field_75098_d) {
                ElectricItem.manager.use(stack, 10000.0, (EntityLivingBase)player);
            }
            return;
        }
        if (this.equals(targetStack, adding)) {
            return;
        }
        this.setBlock(targetStack, adding.getBlock());
        this.setModelState(targetStack, ToolHelper.blockStateToString(adding.getModelState()));
        this.setRenderState(targetStack, ToolHelper.blockStateToString(adding.getRenderState()));
        this.setSide(targetStack, adding.getSide());
        this.setColors(targetStack, adding.getColorMultiplier());
        this.setRotations(targetStack, new byte[adding.getColorMultiplier().length]);
        this.resetLayer(targetStack);
        if (!player.field_71075_bZ.field_75098_d) {
            ElectricItem.manager.use(stack, 10000.0, (EntityLivingBase)player);
        }
    }

    private boolean equals(ItemStack stack, ObscuratorFieldData data) {
        if (data.getBlock() != this.getBlock(stack)) {
            return false;
        }
        if (data.getSide() != this.getSide(stack)) {
            return false;
        }
        if (!Arrays.equals(data.getColorMultiplier(), this.getColors(stack))) {
            return false;
        }
        if (!ToolHelper.blockStateToString(data.getModelState()).equals(this.getModelState(stack))) {
            return false;
        }
        return ToolHelper.blockStateToString(data.getRenderState()).equals(this.getRenderState(stack));
    }

    public boolean hasBlock(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74764_b("Block");
    }

    public String getModelState(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74779_i("model");
    }

    public String getRenderState(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74779_i("render");
    }

    public EnumFacing getSide(ItemStack stack) {
        return EnumFacing.func_82600_a((int)StackUtil.getNbtData(stack).func_74771_c("Side"));
    }

    public Block getBlock(ItemStack stack) {
        return (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(StackUtil.getNbtData(stack).func_74779_i("Block")));
    }

    public int[] getColors(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74759_k("Colors");
    }

    public byte[] getRotations(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74770_j("Rotations");
    }

    private void setModelState(ItemStack stack, String model) {
        StackUtil.getOrCreateNbtData(stack).func_74778_a("model", model);
    }

    private void setRenderState(ItemStack stack, String render) {
        StackUtil.getOrCreateNbtData(stack).func_74778_a("render", render);
    }

    private void setSide(ItemStack stack, EnumFacing side) {
        StackUtil.getOrCreateNbtData(stack).func_74774_a("Side", (byte)side.ordinal());
    }

    private void setBlock(ItemStack stack, Block block) {
        StackUtil.getOrCreateNbtData(stack).func_74778_a("Block", block.getRegistryName().toString());
    }

    private void setColors(ItemStack stack, int[] array) {
        StackUtil.getOrCreateNbtData(stack).func_74783_a("Colors", array);
    }

    private void setRotations(ItemStack stack, byte[] array) {
        StackUtil.getOrCreateNbtData(stack).func_74773_a("Rotations", array);
    }

    public int increaseLayer(ItemStack stack, int limit) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        byte layer = (byte)(nbt.func_74771_c("Layer") + 1);
        if (layer >= limit) {
            layer = 0;
        }
        nbt.func_74774_a("Layer", layer);
        return layer;
    }

    public void resetLayer(ItemStack stack) {
        StackUtil.getOrCreateNbtData(stack).func_74774_a("Layer", (byte)0);
    }

    public void setLayer(ItemStack stack, int layer) {
        StackUtil.getOrCreateNbtData(stack).func_74774_a("Layer", (byte)layer);
    }

    public int getLayer(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74762_e("Layer");
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.BREAKABLE;
    }

    @Override
    public boolean isSpecialSupported(ItemStack item, Enchantment ench) {
        return false;
    }

    @Override
    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_185296_A;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }
}

