/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric.scanners;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.core.item.tool.electric.scanners.IScanner;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.util.math.MathUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ValueDensityScanner
implements IScanner {
    Set<IBlockState> validStates = null;
    Set<Integer> validOreValues = null;
    final byte type;
    LocaleComp name;
    int cost;

    public ValueDensityScanner(int theType, int eu, LocaleComp comp) {
        this.type = (byte)theType;
        this.name = comp;
        this.cost = eu;
    }

    @Override
    public boolean isAdv(ItemStack stack) {
        return false;
    }

    @Override
    public int getOreValue(ItemStack stack, IBlockState state) {
        int value = ClassicRecipes.oreRegistry.getOreValue(state);
        if (this.getValidTypes().contains(value)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getOreValue(ItemStack stack, IBlockState state, World world, BlockPos pos) {
        return this.getOreValue(stack, state);
    }

    @Override
    public Set<IBlockState> getTargets(ItemStack stack) {
        if (this.validStates == null) {
            this.validStates = new LinkedHashSet<IBlockState>();
            Map<Integer, List<IBlockState>> lists = ClassicRecipes.oreRegistry.getValueToOresMap();
            for (int id : this.getValidTypes()) {
                this.validStates.addAll(lists.getOrDefault(id, new ArrayList()));
            }
        }
        return this.validStates;
    }

    @Override
    public int getRadius(ItemStack stack) {
        return 6;
    }

    @Override
    public int getCost(ItemStack stack) {
        return this.cost;
    }

    @Override
    public boolean isValue(ItemStack stack) {
        return false;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 2;
    }

    @Override
    public boolean isFluidScanner(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isFluidValid(ItemStack stack, FluidStack fluid) {
        return false;
    }

    @Override
    public Set<Fluid> getFluidTargets(ItemStack stack) {
        return EMPTY_FLUIDS;
    }

    @Override
    public LocaleComp getName(ItemStack stack) {
        return this.name;
    }

    @Override
    public boolean hasCustomInfo(ItemStack stack) {
        return false;
    }

    @Override
    public boolean addCustomInfo(ItemStack stack, EntityPlayer player, List<String> list, List<String> post, Map<ToolTipType, List<String>> sortedTip) {
        return false;
    }

    @Override
    public boolean showTargets(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasRightClick(ItemStack stack) {
        return false;
    }

    @Override
    public boolean onRightClick(ItemStack stack, EntityPlayer player, EnumHand hand, World world) {
        return false;
    }

    @Override
    public boolean hasAOE(ItemStack stack) {
        return true;
    }

    public Set<Integer> getValidTypes() {
        if (this.validOreValues == null) {
            this.validOreValues = new LinkedHashSet<Integer>(this.validOreValues(this.type));
        }
        return this.validOreValues;
    }

    private List<Integer> validOreValues(int type) {
        switch (type) {
            case 0: {
                return Arrays.asList(0, 1, 2);
            }
            case 1: {
                return Arrays.asList(3, 4);
            }
            case 2: {
                return MathUtil.fromIntToInteger(MathUtil.fromTo(5, ClassicRecipes.oreRegistry.getHighestOreValue()));
            }
        }
        return new ArrayList<Integer>();
    }
}

