/*
 * Decompiled with CFR 0.152.
 */
package net.slayer5934.chococraft.common.items;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.slayer5934.chococraft.common.entities.EntityChocobo;
import net.slayer5934.chococraft.utils.registration.IItemModelProvider;

public class ItemAbilityFruit
extends Item
implements IItemModelProvider {
    public ItemAbilityFruit() {
        this.func_77627_a(true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (AbilityFruitType type : AbilityFruitType.values()) {
            items.add((Object)new ItemStack((Item)this, 1, type.getMeta()));
        }
    }

    @Override
    public void registerItemModel(Item item) {
        ResourceLocation rl = this.getRegistryName();
        assert (rl != null);
        ResourceLocation loc = new ResourceLocation(rl.func_110624_b(), "items/" + rl.func_110623_a());
        for (AbilityFruitType type : AbilityFruitType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)type.getMeta(), (ModelResourceLocation)new ModelResourceLocation(loc, "type=" + type.getName()));
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        AbilityFruitType fruit;
        if (target instanceof EntityChocobo && (fruit = AbilityFruitType.getFromMeta(stack.func_77960_j())).useFruitOn((EntityChocobo)target)) {
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        return super.func_111207_a(stack, playerIn, target, hand);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)(this.func_77667_c(stack) + ".tooltip"), (Object[])new Object[0]));
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + AbilityFruitType.getFromMeta(stack.func_77960_j()).getName();
    }

    public static enum AbilityFruitType {
        SPRINT("spike_fruit", c -> !c.canSprint(), c -> c.setCanSprint(true)),
        GLIDE("aeroshroom", c -> !c.canGlide(), c -> c.setCanGlide(true)),
        DIVE("aqua_berry", c -> !c.canDive(), c -> c.setCanDive(true)),
        FLY("dead_pepper", c -> !c.canFly(), c -> c.setCanFly(true));

        private String name;
        private Consumer<EntityChocobo> abilityApplier;
        private Predicate<EntityChocobo> canLearnAbilityPredicate;

        private AbilityFruitType(String name, Predicate<EntityChocobo> canLearnAbilityPredicate, Consumer<EntityChocobo> abilityApplier) {
            this.name = name;
            this.canLearnAbilityPredicate = canLearnAbilityPredicate;
            this.abilityApplier = abilityApplier;
        }

        public String getName() {
            return this.name;
        }

        public int getMeta() {
            return this.ordinal();
        }

        public static AbilityFruitType getFromMeta(int meta) {
            if (meta < 0 || meta > AbilityFruitType.values().length) {
                return SPRINT;
            }
            return AbilityFruitType.values()[meta];
        }

        public boolean useFruitOn(EntityChocobo chocobo) {
            if (this.canLearnAbilityPredicate.test(chocobo)) {
                this.abilityApplier.accept(chocobo);
                return true;
            }
            return false;
        }
    }
}

