/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.blocks;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pegbeard.dungeontactics.blocks.DTBlockGenericOdd;

public class DTRadio
extends DTBlockGenericOdd
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB NORTH_SOUTH = new AxisAlignedBB(0.208, 0.051, 0.358, 0.792, 0.385, 0.642);
    private static final AxisAlignedBB EAST_WEST = new AxisAlignedBB(0.358, 0.051, 0.208, 0.642, 0.385, 0.792);
    private static final AxisAlignedBB[] BOUNDING_BOX = new AxisAlignedBB[]{NORTH_SOUTH, EAST_WEST, NORTH_SOUTH, EAST_WEST};
    public static ArrayList<ItemRecord> records = new ArrayList();

    public DTRadio(String name, float hardness, float resistance) {
        super(name, Material.field_151575_d, hardness, resistance);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof ItemRecord)) continue;
            records.add((ItemRecord)item);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new DTRadioTile();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return BOUNDING_BOX[facing.func_176736_b()];
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        DTRadio.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOX[facing.func_176736_b()]);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    private void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState iblockstate = world.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = world.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = world.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = world.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.setDefaultFacing(world, pos, state);
    }

    public void markForUpdate(World world, BlockPos pos) {
        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof DTRadioTile) {
            DTRadioTile radio = (DTRadioTile)world.func_175625_s(pos);
            return radio.getTrack();
        }
        return 0;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof DTRadioTile) {
            world.func_175666_e(pos, (Block)this);
        }
        this.mute(world, pos);
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile_entity = world.func_175625_s(pos);
        if (tile_entity instanceof DTRadioTile) {
            DTRadioTile radioTile = (DTRadioTile)tile_entity;
            if (!player.func_70093_af()) {
                if (radioTile.getTrack() == 13) {
                    radioTile.setTrack(records.size());
                } else {
                    radioTile.setTrack(radioTile.getTrack() + 1);
                }
                if (radioTile.getTrack() == records.size()) {
                    radioTile.setTrack(0);
                }
                world.func_175718_b(1010, pos, Item.func_150891_b((Item)((Item)records.get(radioTile.getTrack()))));
            } else if (radioTile.getTrack() != 13) {
                radioTile.setTrack(13);
                this.mute(world, pos);
            }
            if (!world.field_72995_K) {
                this.markForUpdate(world, pos);
            }
        }
        return true;
    }

    public void mute(World world, BlockPos pos) {
        world.func_175718_b(1010, pos, 0);
        world.func_184149_a(pos, null);
    }

    public static class DTRadioTile
    extends TileEntity {
        public int tune;

        public int getTrack() {
            return this.tune;
        }

        public void setTrack(int trackNumber) {
            this.tune = trackNumber;
            this.func_70296_d();
        }

        public void func_145839_a(NBTTagCompound tagCompound) {
            super.func_145839_a(tagCompound);
            this.setTrack(tagCompound.func_74762_e("tune"));
        }

        public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
            super.func_189515_b(tagCompound);
            tagCompound.func_74768_a("tune", this.getTrack());
            return tagCompound;
        }
    }
}

