/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items.books;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.DungeonTactics;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTCreativeTab;

public class DTDungeonpediaBook3
extends ItemWrittenBook {
    public DTDungeonpediaBook3(String name) {
        this.setRegistryName("dungeontactics", name);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77637_a(DTCreativeTab.DT_TAB);
        ItemStack book = new ItemStack(Items.field_151099_bA);
        this.populatePages(book);
    }

    private void populatePages(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        stack.func_77982_d(tag);
        NBTTagList bookPages = new NBTTagList();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("pages")) {
            stack.func_190919_e("pages");
        }
        tag.func_74782_a("pages", (NBTBase)bookPages);
        if (DTConfigHandler.configuration.get("1-Feature", "Seasonal Events", true).getBoolean(true) && DungeonTactics.fools) {
            tag.func_74778_a("author", "\u00ef\u00bf\u00bdkMoomin");
            tag.func_74778_a("title", "Super Useful Guidebook");
            bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl     Book of All\n\n\u00ef\u00bf\u00bdl     Knowledge\n\n\u00ef\u00bf\u00bdl     Volume \u00ef\u00bf\u00bdk999\""));
            bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThis immense collection of books contains all knowledge of life, there-after, and the universe.\""));
            bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdkIf you can read this, you are cheating ;) Happy April Fools Day abcd efg hijk lmnop qrs tuv wxy and z 42\u00ef\u00bf\u00bdr.....\n\n*The ink has run and the words are completely illegible.*\""));
            return;
        }
        tag.func_74778_a("author", "Some probably-dead guy");
        tag.func_74778_a("title", "Trinkets & Charms");
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl   Dungeonpedia\n\n\u00ef\u00bf\u00bdl     Volume 3\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThis volume contains information on Trinkets and Charms you may come across.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl     Trinkets\n\nTrinkets are enchanted jewelery. They can be worn by placing them in you inventory and activated to grant numerous effects, at the cost of speeding up your metabolism.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Bone Charms\n\nDespite there grim visage, the charms protect the user. They work in the similarly to Trinkets, except that they remove negative effects from the user and do not stay active.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nLegends speak of a Bone Charm that is able to protect the holder from any ailment.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Speed Boost\n\nIncreases the user's agility, allowing them to move more quickly.\nLow Cost\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Jump Boost\n\nIncreases the user's acrobatic skill, allowing them to jump higher.\nLow Cost\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl   Mining Haste\n\nAllows the user to strike more efficiently and effectively.\nLow Cost\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl       Gills\n\nGives the user all the powers of Aquaman, the coolest Justice League Hero, except his ability to talk to fish, or swim fast. Trident sold sepperately.\nMedium Cost\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Fire Shield\n\nProtects the user from hot stuff, but not hot topic.\nMedium Cost\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Night Sight\n\nTorches are for Muggles.\nMedium Cost\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Stone Skin\n\nAllows the user to glance off blows as if their skin were made from a really hard substance... Like some sort of hardened dirt...\nMedium Cost\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl     Strength\n\nHulk Smash!\nHigh Cost\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl     Ghostly\n\nNot for use in public changing rooms.\nHigh Cost\""));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77978_p() == null) {
            this.populatePages(itemstack);
        }
        if (!world.field_72995_K) {
            this.resolveContents(itemstack, player);
        }
        if (world.field_72995_K) {
            DungeonTactics.INSTANCE.openDungeonBook(player, itemstack, false);
        }
        player.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public static boolean validBookTagContents(NBTTagCompound nbt) {
        if (!ItemWritableBook.func_150930_a((NBTTagCompound)nbt)) {
            return false;
        }
        if (!nbt.func_150297_b("title", 8)) {
            return false;
        }
        String s = nbt.func_74779_i("title");
        return s != null && s.length() <= 32 ? nbt.func_150297_b("author", 8) : false;
    }

    public static int getGeneration(ItemStack book) {
        return book.func_77978_p().func_74762_e("generation");
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound nbttagcompound;
        String s;
        if (stack.func_77942_o() && !StringUtils.func_151246_b((String)(s = (nbttagcompound = stack.func_77978_p()).func_74779_i("title")))) {
            return s;
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbttagcompound = stack.func_77978_p();
            String s = nbttagcompound.func_74779_i("author");
            if (!StringUtils.func_151246_b((String)s)) {
                tooltip.add(TextFormatting.GRAY + I18n.func_74837_a((String)"book.byAuthor", (Object[])new Object[]{s}));
            }
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)("book.generation." + nbttagcompound.func_74762_e("generation"))));
        }
    }

    private void resolveContents(ItemStack stack, EntityPlayer player) {
        NBTTagCompound nbttagcompound;
        if (stack.func_77978_p() != null && !(nbttagcompound = stack.func_77978_p()).func_74767_n("resolved")) {
            nbttagcompound.func_74757_a("resolved", true);
            if (DTDungeonpediaBook3.validBookTagContents(nbttagcompound)) {
                NBTTagList nbttaglist = nbttagcompound.func_150295_c("pages", 8);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    ITextComponent itextcomponent;
                    String s = nbttaglist.func_150307_f(i);
                    try {
                        itextcomponent = ITextComponent.Serializer.func_186877_b((String)s);
                        itextcomponent = TextComponentUtils.func_179985_a((ICommandSender)player, (ITextComponent)itextcomponent, (Entity)player);
                    }
                    catch (Exception var9) {
                        itextcomponent = new TextComponentString(s);
                    }
                    nbttaglist.func_150304_a(i, (NBTBase)new NBTTagString(ITextComponent.Serializer.func_150696_a((ITextComponent)itextcomponent)));
                }
                nbttagcompound.func_74782_a("pages", (NBTBase)nbttaglist);
                if (player instanceof EntityPlayerMP && player.func_184614_ca() == stack) {
                    Slot slot = player.field_71070_bA.func_75147_a((IInventory)player.field_71071_by, player.field_71071_by.field_70461_c);
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(0, slot.field_75222_d, stack));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }
}

