/*
 * Decompiled with CFR 0.152.
 */
package therealfarfetchd.quacklib.common.block;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import therealfarfetchd.quacklib.common.api.extensions.VectorsKt;
import therealfarfetchd.quacklib.common.api.extensions.WorldsKt;
import therealfarfetchd.quacklib.common.api.qblock.IQBlockMultiblock;
import therealfarfetchd.quacklib.common.api.qblock.QBContainer;
import therealfarfetchd.quacklib.common.api.qblock.QBlock;
import therealfarfetchd.quacklib.common.api.util.QNBTCompound;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Ltherealfarfetchd/quacklib/common/block/MultiblockExtension;", "", "()V", "getMainBlock", "Ltherealfarfetchd/quacklib/common/api/qblock/QBlock;", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "getMainBlockM", "Ltherealfarfetchd/quacklib/common/api/qblock/IQBlockMultiblock;", "getMainBlockPos", "Block", "Tile", "QuackLib"})
public final class MultiblockExtension {
    public static final MultiblockExtension INSTANCE;

    @NotNull
    public final BlockPos getMainBlockPos(@NotNull IBlockAccess world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof Tile)) {
            tileEntity = null;
        }
        Tile tile = (Tile)tileEntity;
        if (tile == null) {
            Intrinsics.throwNpe();
        }
        return VectorsKt.plus((Vec3i)tile.getRootOffset$QuackLib(), (Vec3i)pos);
    }

    @Nullable
    public final QBlock getMainBlock(@NotNull IBlockAccess world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        BlockPos mpos = this.getMainBlockPos(world, pos);
        IBlockState iBlockState = world.func_180495_p(mpos);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(mpos)");
        return iBlockState.func_177230_c() instanceof QBContainer ? WorldsKt.getQBlock(world, mpos) : null;
    }

    @Nullable
    public final IQBlockMultiblock getMainBlockM(@NotNull IBlockAccess world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        QBlock qBlock = this.getMainBlock(world, pos);
        if (!(qBlock instanceof IQBlockMultiblock)) {
            qBlock = null;
        }
        return (IQBlockMultiblock)((Object)qBlock);
    }

    private MultiblockExtension() {
    }

    static {
        MultiblockExtension multiblockExtension;
        INSTANCE = multiblockExtension = new MultiblockExtension();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\"\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J\u0012\u0010 \u001a\u00020!2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J(\u0010\"\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010#\u001a\u00020$2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010%\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010&\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010'\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016JP\u0010(\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u0019H\u0016J0\u0010/\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u0005H\u0016\u00a8\u00061"}, d2={"Ltherealfarfetchd/quacklib/common/block/MultiblockExtension$Block;", "Lnet/minecraft/block/Block;", "Lnet/minecraft/block/ITileEntityProvider;", "()V", "canHarvestBlock", "", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "createNewTileEntity", "Ltherealfarfetchd/quacklib/common/block/MultiblockExtension$Tile;", "worldIn", "Lnet/minecraft/world/World;", "meta", "", "getBlockFaceShape", "Lnet/minecraft/block/state/BlockFaceShape;", "state", "Lnet/minecraft/block/state/IBlockState;", "face", "Lnet/minecraft/util/EnumFacing;", "getBlockHardness", "", "blockState", "getItemDropped", "", "rand", "Ljava/util/Random;", "fortune", "getMobilityFlag", "Lnet/minecraft/block/material/EnumPushReaction;", "getPlayerRelativeBlockHardness", "getRenderType", "Lnet/minecraft/util/EnumBlockRenderType;", "isFullCube", "isOpaqueCube", "isTopSolid", "onBlockActivated", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "hitX", "hitY", "hitZ", "removedByPlayer", "willHarvest", "QuackLib"})
    public static final class Block
    extends net.minecraft.block.Block
    implements ITileEntityProvider {
        public static final Block INSTANCE;

        public boolean func_180639_a(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull EnumFacing facing2, float hitX, float hitY, float hitZ) {
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
            Intrinsics.checkParameterIsNotNull((Object)facing2, (String)"facing");
            IQBlockMultiblock qb = INSTANCE.getMainBlockM((IBlockAccess)world, pos);
            if (qb == null) {
                world.func_175698_g(pos);
                return true;
            }
            return qb.onActivatedRemote(player, hand, facing2, pos, hitX, hitY, hitZ);
        }

        public float func_176195_g(@Nullable IBlockState blockState, @NotNull World world, @NotNull BlockPos pos) {
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            BlockPos mpos = INSTANCE.getMainBlockPos((IBlockAccess)world, pos);
            if (Intrinsics.areEqual((Object)mpos, (Object)pos)) {
                return -1.0f;
            }
            return world.func_180495_p(mpos).func_185887_b(world, mpos);
        }

        public float func_180647_a(@NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos) {
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            BlockPos mpos = INSTANCE.getMainBlockPos((IBlockAccess)world, pos);
            if (Intrinsics.areEqual((Object)mpos, (Object)pos)) {
                return 0.0f;
            }
            return world.func_180495_p(mpos).func_185903_a(player, world, mpos);
        }

        public boolean canHarvestBlock(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityPlayer player) {
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            BlockPos mpos = INSTANCE.getMainBlockPos(world, pos);
            IBlockState iBlockState = world.func_180495_p(mpos);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(mpos)");
            return iBlockState.func_177230_c().canHarvestBlock(world, mpos, player);
        }

        public boolean removedByPlayer(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull EntityPlayer player, boolean willHarvest) {
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            BlockPos mpos = INSTANCE.getMainBlockPos((IBlockAccess)world, pos);
            IQBlockMultiblock iQBlockMultiblock = INSTANCE.getMainBlockM((IBlockAccess)world, pos);
            if (iQBlockMultiblock == null) {
                return super.removedByPlayer(state, world, pos, player, willHarvest);
            }
            IQBlockMultiblock b = iQBlockMultiblock;
            b.onRemoteBreak(VectorsKt.minus((Vec3i)pos, (Vec3i)mpos), player);
            return false;
        }

        public boolean func_149662_c(@Nullable IBlockState state) {
            return false;
        }

        public boolean func_149686_d(@Nullable IBlockState state) {
            return false;
        }

        @NotNull
        public EnumBlockRenderType func_149645_b(@Nullable IBlockState state) {
            return EnumBlockRenderType.INVISIBLE;
        }

        public boolean func_185481_k(@Nullable IBlockState state) {
            return false;
        }

        @NotNull
        public BlockFaceShape func_193383_a(@Nullable IBlockAccess worldIn, @Nullable IBlockState state, @Nullable BlockPos pos, @Nullable EnumFacing face) {
            return BlockFaceShape.UNDEFINED;
        }

        @NotNull
        public EnumPushReaction func_149656_h(@Nullable IBlockState state) {
            return EnumPushReaction.BLOCK;
        }

        @Nullable
        public Void getItemDropped(@Nullable IBlockState state, @Nullable Random rand, int fortune) {
            return null;
        }

        @NotNull
        public Tile createNewTileEntity(@Nullable World worldIn, int meta) {
            return new Tile();
        }

        private Block() {
            super(Material.field_151576_e);
        }

        static {
            Block block2;
            INSTANCE = block2 = new Block();
            block2.setRegistryName("quacklib", "multiblock1");
            block2.func_149713_g(0);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\t\u001a\u0004\u0018\u0001H\n\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0014H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Ltherealfarfetchd/quacklib/common/block/MultiblockExtension$Tile;", "Lnet/minecraft/tileentity/TileEntity;", "()V", "rootOffset", "Lnet/minecraft/util/math/BlockPos;", "getRootOffset$QuackLib", "()Lnet/minecraft/util/math/BlockPos;", "setRootOffset$QuackLib", "(Lnet/minecraft/util/math/BlockPos;)V", "getCapability", "T", "", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getUpdatePacket", "Lnet/minecraft/network/play/server/SPacketUpdateTileEntity;", "getUpdateTag", "Lnet/minecraft/nbt/NBTTagCompound;", "hasCapability", "", "onDataPacket", "", "net", "Lnet/minecraft/network/NetworkManager;", "pkt", "readFromNBT", "nbt", "writeToNBT", "QuackLib"})
    public static final class Tile
    extends TileEntity {
        @NotNull
        private BlockPos rootOffset;

        @NotNull
        public final BlockPos getRootOffset$QuackLib() {
            return this.rootOffset;
        }

        public final void setRootOffset$QuackLib(@NotNull BlockPos blockPos) {
            Intrinsics.checkParameterIsNotNull((Object)blockPos, (String)"<set-?>");
            this.rootOffset = blockPos;
        }

        @NotNull
        public NBTTagCompound func_189515_b(@NotNull NBTTagCompound nbt2) {
            QNBTCompound qNBTCompound;
            Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
            super.func_189515_b(nbt2);
            QNBTCompound $receiver = qNBTCompound = new QNBTCompound(nbt2);
            $receiver.getUshort().set("xO", this.rootOffset.func_177958_n());
            $receiver.getUshort().set("yO", this.rootOffset.func_177956_o());
            $receiver.getUshort().set("zO", this.rootOffset.func_177952_p());
            return nbt2;
        }

        public void func_145839_a(@NotNull NBTTagCompound nbt2) {
            QNBTCompound qNBTCompound;
            Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
            super.func_145839_a(nbt2);
            QNBTCompound $receiver = qNBTCompound = new QNBTCompound(nbt2);
            this.rootOffset = new BlockPos((int)((Number)$receiver.getShort().get("xO")).shortValue(), (int)((Number)$receiver.getShort().get("yO")).shortValue(), (int)((Number)$receiver.getShort().get("zO")).shortValue());
        }

        @NotNull
        public NBTTagCompound func_189517_E_() {
            return this.func_189515_b(new NBTTagCompound());
        }

        @Nullable
        public SPacketUpdateTileEntity func_189518_D_() {
            return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
        }

        public void onDataPacket(@NotNull NetworkManager net, @NotNull SPacketUpdateTileEntity pkt) {
            Intrinsics.checkParameterIsNotNull((Object)net, (String)"net");
            Intrinsics.checkParameterIsNotNull((Object)pkt, (String)"pkt");
            NBTTagCompound nBTTagCompound = pkt.func_148857_g();
            Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"pkt.nbtCompound");
            this.func_145839_a(nBTTagCompound);
        }

        public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing2) {
            Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
            return super.hasCapability(capability, facing2);
        }

        @Nullable
        public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing2) {
            Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
            return (T)super.getCapability(capability, facing2);
        }

        public Tile() {
            BlockPos blockPos = BlockPos.field_177992_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"BlockPos.ORIGIN");
            this.rootOffset = blockPos;
        }
    }
}

