/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.transformers;

import com.google.common.collect.Sets;
import gnu.trove.map.TObjectDoubleMap;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import ivorius.ivtoolkit.blocks.BlockAreas;
import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.blocks.IvMutableBlockPos;
import ivorius.ivtoolkit.random.BlurredValueField;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.ivtoolkit.world.chunk.gen.StructureBoundingBoxes;
import ivorius.reccomplex.nbt.NBTStorable;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLiveContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.RunTransformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.Transformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerMulti;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;

public abstract class TransformerAbstractCloud<S extends InstanceData>
extends Transformer<S> {
    public TransformerAbstractCloud(@Nonnull String id) {
        super(id);
    }

    public static <T> boolean visitRecursively(HashSet<T> start, BiPredicate<Set<T>, T> changedConsumer) {
        HashSet<T> changedL = start;
        HashSet changedR = new HashSet();
        while (changedL.size() > 0 || changedR.size() > 0) {
            HashSet<Object> current = changedL.size() > 0 ? changedL : changedR;
            HashSet<Object> next = current == changedL ? changedR : changedL;
            for (Object e : current) {
                if (changedConsumer.test(next, e)) continue;
                return false;
            }
            current.clear();
        }
        return true;
    }

    public abstract double cloudExpansionDistance();

    public abstract double cloudExpansionRandomization();

    @Override
    public boolean skipGeneration(S instanceData, StructureLiveContext context, BlockPos pos, IBlockState state, IvWorldData worldData, BlockPos sourcePos) {
        return this.matches(instanceData, state);
    }

    public TObjectDoubleMap<BlockPos> buildCloud(S instanceData, IvWorldData worldData, StructurePrepareContext context, TransformerMulti transformer, TransformerMulti.InstanceData transformerInstanceData) {
        Random random = context.random;
        Environment environment = context.environment;
        BlockPos lowerCoord = StructureBoundingBoxes.min(context.boundingBox);
        int[] strucSize = new int[]{worldData.blockCollection.width, worldData.blockCollection.height, worldData.blockCollection.length};
        TObjectDoubleHashMap cloud = new TObjectDoubleHashMap();
        BlurredValueField blurredValueField = new BlurredValueField(strucSize);
        int gridCoords = 1;
        for (int d : strucSize) {
            gridCoords *= d;
        }
        int values = MathHelper.func_76141_d((float)((float)gridCoords * 0.04f + 0.5f));
        for (int i = 0; i < values; ++i) {
            blurredValueField.addValue(1.0f + (random.nextFloat() - random.nextFloat()) * (float)this.cloudExpansionRandomization() / 100.0f, random);
        }
        BlockAreas.mutablePositions(worldData.blockCollection.area()).forEach(arg_0 -> this.lambda$buildCloud$0(worldData, context, strucSize, lowerCoord, instanceData, environment, transformer, transformerInstanceData, (TObjectDoubleMap)cloud, arg_0));
        double expansionDistance = this.cloudExpansionDistance();
        BlockPos.MutableBlockPos sidePos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos sideWorldCoord = new BlockPos.MutableBlockPos();
        if (expansionDistance > 1.0E-6) {
            double[] sideFalloffs = new double[6];
            ArrayList<EnumFacing> checkSides = new ArrayList<EnumFacing>();
            for (EnumFacing side : EnumFacing.values()) {
                double sideFalloff;
                double sideExpansionDistance = this.cloudExpansionDistance(side);
                double d = sideFalloff = sideExpansionDistance > 1.0E-6 ? 1.0 / sideExpansionDistance / expansionDistance : 0.0;
                if (!(sideFalloff > 0.0)) continue;
                checkSides.add(side);
                sideFalloffs[side.func_176745_a()] = sideFalloff;
            }
            TransformerAbstractCloud.visitRecursively(Sets.newHashSet((Iterable)cloud.keySet()), (arg_0, arg_1) -> this.lambda$buildCloud$1((TObjectDoubleMap)cloud, checkSides, sideFalloffs, sidePos, blurredValueField, context, sideWorldCoord, strucSize, lowerCoord, environment, worldData, transformer, transformerInstanceData, arg_0, arg_1));
        }
        return cloud;
    }

    public boolean canPenetrate(Environment environment, IvWorldData worldData, BlockPos pos, double density, TransformerMulti transformer, TransformerMulti.InstanceData transformerID) {
        return true;
    }

    protected double cloudExpansionDistance(EnumFacing side) {
        return 1.0;
    }

    @Override
    public void configureInstanceData(S s, StructurePrepareContext context, IvWorldData worldData, RunTransformer transformer) {
        ((InstanceData)s).cloud = this.buildCloud(s, worldData, context, transformer.transformer, transformer.instanceData);
    }

    @Override
    public void transform(S instanceData, Transformer.Phase phase, StructureSpawnContext context, IvWorldData worldData, RunTransformer transformer) {
        if (this.generatesInPhase(instanceData, phase)) {
            IvBlockCollection blockCollection = worldData.blockCollection;
            int[] areaSize = new int[]{blockCollection.width, blockCollection.height, blockCollection.length};
            BlockPos lowerCoord = StructureBoundingBoxes.min(context.boundingBox);
            BlockPos.MutableBlockPos worldCoord = new BlockPos.MutableBlockPos();
            ((InstanceData)instanceData).cloud.forEachEntry((sourcePos, density) -> {
                IvMutableBlockPos.add(context.transform.applyOn((BlockPos)sourcePos, worldCoord, areaSize), lowerCoord);
                this.transformBlock(instanceData, phase, context, (BlockPos)sourcePos, (BlockPos)worldCoord, worldData.blockCollection.getBlockState((BlockPos)sourcePos), density);
                return true;
            });
        }
    }

    public abstract boolean generatesInPhase(S var1, Transformer.Phase var2);

    public abstract boolean matches(S var1, IBlockState var2);

    public abstract void transformBlock(S var1, Transformer.Phase var2, StructureSpawnContext var3, BlockPos var4, BlockPos var5, IBlockState var6, double var7);

    private /* synthetic */ boolean lambda$buildCloud$1(TObjectDoubleMap cloud, List checkSides, double[] sideFalloffs, BlockPos.MutableBlockPos sidePos, BlurredValueField blurredValueField, StructurePrepareContext context, BlockPos.MutableBlockPos sideWorldCoord, int[] strucSize, BlockPos lowerCoord, Environment environment, IvWorldData worldData, TransformerMulti transformer, TransformerMulti.InstanceData transformerInstanceData, Set changed, BlockPos pos) {
        double density = cloud.get((Object)pos);
        for (EnumFacing side : checkSides) {
            double sideFalloff = sideFalloffs[side.func_176745_a()];
            IvMutableBlockPos.offset(pos, sidePos, side);
            double sideDensity = density - sideFalloff * blurredValueField.getValue(sidePos.func_177958_n(), sidePos.func_177956_o(), sidePos.func_177952_p());
            if (sideDensity <= 0.0 || cloud.get((Object)sidePos) >= sideDensity - 1.0E-5) continue;
            IvMutableBlockPos.add(context.transform.applyOn((BlockPos)sidePos, sideWorldCoord, strucSize), lowerCoord);
            if (!this.canPenetrate(environment, worldData, (BlockPos)sideWorldCoord, sideDensity, transformer, transformerInstanceData)) continue;
            BlockPos immutableSidePos = sidePos.func_185334_h();
            cloud.put((Object)immutableSidePos, sideDensity);
            changed.add(immutableSidePos);
        }
        return true;
    }

    private /* synthetic */ void lambda$buildCloud$0(IvWorldData worldData, StructurePrepareContext context, int[] strucSize, BlockPos lowerCoord, InstanceData instanceData, Environment environment, TransformerMulti transformer, TransformerMulti.InstanceData transformerInstanceData, TObjectDoubleMap cloud, BlockPos.MutableBlockPos pos) {
        IBlockState state = worldData.blockCollection.getBlockState((BlockPos)pos);
        BlockPos worldCoord = context.transform.apply((BlockPos)pos, strucSize).func_177971_a((Vec3i)lowerCoord);
        if (this.matches(instanceData, state) && this.canPenetrate(environment, worldData, worldCoord, 1.0, transformer, transformerInstanceData)) {
            cloud.put((Object)pos.func_185334_h(), 1.0);
        }
    }

    public static class InstanceData
    implements NBTStorable {
        public TObjectDoubleMap<BlockPos> cloud = new TObjectDoubleHashMap();

        public void readFromNBT(NBTBase base) {
            NBTTagCompound compound = base instanceof NBTTagCompound ? (NBTTagCompound)base : new NBTTagCompound();
            NBTTagLists.compoundsFrom(compound, "cloud").forEach(cloudCompound -> {
                BlockPos pos = BlockPositions.readFromNBT("particle", cloudCompound);
                if (pos != null) {
                    this.cloud.put((Object)pos, cloudCompound.func_74769_h("density"));
                }
            });
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            ArrayList cloudCompounds = new ArrayList();
            this.cloud.forEachEntry((pos, density) -> {
                NBTTagCompound cloudCompound = new NBTTagCompound();
                BlockPositions.writeToNBT("particle", pos, cloudCompound);
                cloudCompound.func_74780_a("density", density);
                cloudCompounds.add(cloudCompound);
                return true;
            });
            NBTTagLists.writeTo(compound, "cloud", cloudCompounds);
            return compound;
        }
    }
}

