/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.proxy;

import java.io.File;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.silvercatcher.reforged.ReforgedEvents;
import org.silvercatcher.reforged.ReforgedMod;
import org.silvercatcher.reforged.ReforgedMonsterArmourer;
import org.silvercatcher.reforged.ReforgedReferences;
import org.silvercatcher.reforged.ReforgedRegistry;
import org.silvercatcher.reforged.api.ReforgedAdditions;
import org.silvercatcher.reforged.entities.EntityBoomerang;
import org.silvercatcher.reforged.entities.EntityBulletBlunderbuss;
import org.silvercatcher.reforged.entities.EntityBulletMusket;
import org.silvercatcher.reforged.entities.EntityCrossbowBolt;
import org.silvercatcher.reforged.entities.EntityDart;
import org.silvercatcher.reforged.entities.EntityDynamite;
import org.silvercatcher.reforged.entities.EntityJavelin;
import org.silvercatcher.reforged.entities.TileEntityCaltrop;
import org.silvercatcher.reforged.props.DefaultStunImpl;
import org.silvercatcher.reforged.props.IStunProperty;
import org.silvercatcher.reforged.props.StorageStun;

public class CommonProxy {
    public static final String[] sounds = new String[]{"boomerang_break", "boomerang_hit", "boomerang_throw", "crossbow_reload", "crossbow_shoot", "musket_shoot", "shotgun_reload", "shotgun_shoot"};
    public static boolean battleaxe;
    public static boolean blowgun;
    public static boolean boomerang;
    public static boolean firerod;
    public static boolean javelin;
    public static boolean katana;
    public static boolean knife;
    public static boolean musket;
    public static boolean nest_of_bees;
    public static boolean sabre;
    public static boolean keris;
    public static boolean caltrop;
    public static boolean dynamite;
    public static boolean crossbow;
    public static boolean pike;
    public static boolean mace;
    public static boolean dirk;
    public static float damage_musket;
    public static float damage_caltrop;
    public static int goalseekerid;
    public static final String items = "Items";
    public static final String ids = "IDs";
    public static final String floats = "General";

    public static SoundEvent getSound(String name) {
        return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("reforged", name));
    }

    public void init(FMLInitializationEvent event) {
    }

    private void loadConfig(FMLPreInitializationEvent e) {
        File configdir = new File(e.getModConfigurationDirectory(), "Reforged");
        File configfile = new File(configdir, "reforged.cfg");
        if (!configfile.exists()) {
            configdir.mkdirs();
        }
        Configuration config = new Configuration(configfile);
        config.load();
        battleaxe = config.getBoolean("Battleaxe", items, true, "Enable the Battleaxe");
        blowgun = config.getBoolean("Blowgun", items, true, "Enable the Blowgun plus Darts");
        boomerang = config.getBoolean("Boomerang", items, true, "Enable the Boomerang");
        firerod = config.getBoolean("Firerod", items, true, "Enable the Firerod");
        javelin = config.getBoolean("Javelin", items, true, "Enable the Javelin");
        katana = config.getBoolean("Katana", items, true, "Enable the Katana");
        knife = config.getBoolean("Knife", items, true, "Enable the Knife");
        musket = config.getBoolean("Musket", items, true, "Enable the Musket and Blunderbuss");
        nest_of_bees = config.getBoolean("Nest Of Bees", items, true, "Enable the Nest Of Bees");
        sabre = config.getBoolean("Sabre", items, true, "Enable the Sabre");
        keris = config.getBoolean("Kris", items, true, "Enable the Kris");
        caltrop = config.getBoolean("Caltrop", items, true, "Enable the Caltrop");
        dynamite = config.getBoolean("Dynamite", items, true, "Enable the Dynamite");
        crossbow = config.getBoolean("Crossbow", items, true, "Enable the Crossbow plus Bolt");
        pike = config.getBoolean("Pike", items, true, "Enable the Pike");
        mace = config.getBoolean("Mace", items, true, "Enable the Mace");
        dirk = config.getBoolean("Dirk", items, true, "Enable the Dirk");
        damage_musket = config.getFloat("Musket Damage", floats, 10.0f, 1.0f, 50.0f, "Damage of the Musket");
        damage_caltrop = config.getFloat("Caltrop Damage", floats, 8.0f, 1.0f, 50.0f, "Damage of the Caltrop");
        goalseekerid = config.getInt("Goalseeker", ids, 100, 0, 256, "This specifies the Enchantment ID of the Goalseeker-Enchantment");
        config.save();
    }

    public void postInit(FMLPostInitializationEvent event) {
        ReforgedMod.battlegearDetected = Loader.isModLoaded((String)"battlegear2");
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.loadConfig(event);
        ReforgedRegistry.registerEventHandler(this);
        ReforgedRegistry.registerEventHandler(new ReforgedRegistry());
        ReforgedRegistry.registerEventHandler(new ReforgedEvents());
        ReforgedRegistry.registerEventHandler(new ReforgedMonsterArmourer());
        ReforgedRegistry.createItems();
        ReforgedRegistry.registerPackets();
        CapabilityManager.INSTANCE.register(IStunProperty.class, (Capability.IStorage)new StorageStun(), DefaultStunImpl.class);
        this.registerEntities();
    }

    @SubscribeEvent
    public void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().register(ReforgedAdditions.goalseeker.setRegistryName(new ResourceLocation("reforged", "goalseeker")));
    }

    private void registerEntities() {
        if (ReforgedReferences.GlobalValues.BOOMERANG) {
            ReforgedRegistry.registerEntity(EntityBoomerang.class, "Boomerang");
        }
        if (ReforgedReferences.GlobalValues.JAVELIN) {
            ReforgedRegistry.registerEntity(EntityJavelin.class, "Javelin");
        }
        if (ReforgedReferences.GlobalValues.MUSKET) {
            ReforgedRegistry.registerEntity(EntityBulletMusket.class, "BulletMusket");
            ReforgedRegistry.registerEntity(EntityBulletBlunderbuss.class, "BulletBlunderbuss");
        }
        if (ReforgedReferences.GlobalValues.CROSSBOW) {
            ReforgedRegistry.registerEntity(EntityCrossbowBolt.class, "CrossbowBolt");
        }
        if (ReforgedReferences.GlobalValues.BLOWGUN) {
            ReforgedRegistry.registerEntity(EntityDart.class, "Dart");
        }
        if (ReforgedReferences.GlobalValues.CALTROP) {
            GameRegistry.registerTileEntity(TileEntityCaltrop.class, (String)"Caltrop");
        }
        if (ReforgedReferences.GlobalValues.DYNAMITE) {
            ReforgedRegistry.registerEntity(EntityDynamite.class, "Dynamite");
        }
    }

    protected void registerEntityRenderers() {
    }

    public void registerItemRenderer(Item item, int meta, String id) {
    }

    protected void registerItemRenderers(ModelRegistryEvent event) {
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry reg = event.getRegistry();
        for (String s : sounds) {
            ResourceLocation loc = new ResourceLocation("reforged", s);
            reg.register(new SoundEvent(loc).setRegistryName(loc));
        }
    }
}

