/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui.controls;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAnalogeSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.premade.SubContainerEmpty;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.packet.gui.GuiLayerPacket;
import com.creativemd.littletiles.common.util.animation.event.PlaySoundEvent;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public class SubGuiSoundSelector
extends SubGui {
    public GuiPickSoundButton button;
    public List<String> possibleLines;
    public String selected;

    public SubGuiSoundSelector(GuiPickSoundButton button) {
        this.button = button;
        this.possibleLines = new ArrayList<String>();
        for (ResourceLocation location : SoundEvent.field_187505_a.func_148742_b()) {
            this.possibleLines.add(location.toString());
        }
        this.selected = button.selected != null ? button.selected.getRegistryName().toString() : null;
    }

    public void createControls() {
        GuiTextfield search = new GuiTextfield("search", "", 0, 0, 165, 14);
        this.controls.add(search);
        this.controls.add(new GuiComboBox("sounds", 0, 22, 165, new ArrayList()));
        this.controls.add(new GuiLabel(SubGuiSoundSelector.translate((String)"gui.sound.volume") + ":", 0, 44));
        this.controls.add(new GuiAnalogeSlider("volume", 60, 44, 60, 8, (double)this.button.volume, 0.0, 1.0));
        this.controls.add(new GuiLabel(SubGuiSoundSelector.translate((String)"gui.sound.pitch") + ":", 0, 64));
        this.controls.add(new GuiAnalogeSlider("pitch", 60, 64, 60, 8, (double)this.button.pitch, 0.5, 2.0));
        this.controls.add(new GuiButton("play", 144, 44){

            public void onClicked(int x, int y, int button) {
                SoundEvent event = SubGuiSoundSelector.this.getSelected();
                if (event != null) {
                    1.playSound((SoundEvent)event, (float)SubGuiSoundSelector.this.getVolume(), (float)SubGuiSoundSelector.this.getPitch());
                }
            }
        });
        this.controls.add(new GuiButton("save", 140, 143){

            public void onClicked(int x, int y, int button) {
                SubGuiSoundSelector.this.button.selected = SubGuiSoundSelector.this.getSelected();
                SubGuiSoundSelector.this.button.volume = SubGuiSoundSelector.this.getVolume();
                SubGuiSoundSelector.this.button.pitch = SubGuiSoundSelector.this.getPitch();
                SubGuiSoundSelector.this.closeGui();
                SubGuiSoundSelector.this.button.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)SubGuiSoundSelector.this.button));
            }
        });
        this.controls.add(new GuiButton("cancel", 0, 143){

            public void onClicked(int x, int y, int button) {
                SubGuiSoundSelector.this.closeGui();
            }
        });
        this.onChanged(new GuiControlChangedEvent((GuiControl)search));
    }

    @CustomEventSubscribe
    public void onChanged(GuiControlChangedEvent event) {
        GuiComboBox sounds = (GuiComboBox)this.get("sounds");
        GuiTextfield search = (GuiTextfield)this.get("search");
        if (event.source != null) {
            if (event.source.is(new String[]{"sounds"})) {
                this.selected = sounds.caption;
            } else if (event.source.is(new String[]{"search"})) {
                ArrayList<String> foundLines = new ArrayList<String>();
                if (search.text.isEmpty()) {
                    foundLines.addAll(this.possibleLines);
                } else {
                    for (int i = 0; i < this.possibleLines.size(); ++i) {
                        if (!this.possibleLines.get(i).contains(search.text)) continue;
                        foundLines.add(this.possibleLines.get(i));
                    }
                }
                sounds.lines = foundLines;
                sounds.index = foundLines.indexOf(this.selected);
                sounds.caption = this.selected;
            }
        }
    }

    public void onClosed() {
        this.button.gui = null;
    }

    public float getPitch() {
        GuiAnalogeSlider pitch = (GuiAnalogeSlider)this.get("pitch");
        return (float)pitch.value;
    }

    public float getVolume() {
        GuiAnalogeSlider volume = (GuiAnalogeSlider)this.get("volume");
        return (float)volume.value;
    }

    public SoundEvent getSelected() {
        ResourceLocation location = this.getSelectionLocation();
        if (location != null) {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)location);
        }
        return null;
    }

    public ResourceLocation getSelectionLocation() {
        if (this.selected != null && !this.selected.isEmpty()) {
            return new ResourceLocation(this.selected);
        }
        return null;
    }

    public static class GuiPickSoundButton
    extends GuiButton {
        public SubGuiSoundSelector gui;
        public SoundEvent selected;
        public float volume;
        public float pitch;

        public GuiPickSoundButton(String name, int x, int y, @Nullable PlaySoundEvent event) {
            super(name, GuiPickSoundButton.translate((String)"gui.door.pick-sound"), x, y, 50, 7);
            if (event != null) {
                this.selected = event.sound;
                this.volume = event.volume;
                this.pitch = event.pitch;
            } else {
                this.volume = 1.0f;
                this.pitch = 1.0f;
            }
        }

        public void onClicked(int x, int y, int button) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("dialog", true);
            SubGuiSoundSelector dialog = new SubGuiSoundSelector(this);
            dialog.gui = this.getParent().getOrigin().gui;
            PacketHandler.sendPacketToServer((CreativeCorePacket)new GuiLayerPacket(nbt, dialog.gui.getLayers().size() - 1, false));
            dialog.container = new SubContainerEmpty(this.getPlayer());
            dialog.gui.addLayer((SubGui)dialog);
            dialog.onOpened();
        }
    }
}

