/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.tile;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedQuad;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.CubeObject;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.client.render.tile.LittleDynamicCube;
import com.creativemd.littletiles.client.render.tile.LittleRenderingCube;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.tile.math.box.slice.LittleSlice;
import com.creativemd.littletiles.common.tile.math.box.slice.LittleSlicedOrdinaryBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EnumFaceDirection;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class LittleSlicedOrdinaryRenderingCube
extends LittleRenderingCube {
    protected LittleDynamicCube dynamicCube;

    public LittleSlicedOrdinaryRenderingCube(CubeObject cube, LittleSlicedOrdinaryBox box, Block block, int meta) {
        super(cube, box, block, meta);
        this.dynamicCube = new LittleDynamicCube((CubeObject)this, box.slice, box.getSize());
    }

    public CubeObject offset(BlockPos pos) {
        return new LittleSlicedOrdinaryRenderingCube(new CubeObject(this.minX - (float)pos.func_177958_n(), this.minY - (float)pos.func_177956_o(), this.minZ - (float)pos.func_177952_p(), this.maxX - (float)pos.func_177958_n(), this.maxY - (float)pos.func_177956_o(), this.maxZ - (float)pos.func_177952_p(), (CubeObject)this), (LittleSlicedOrdinaryBox)this.box, this.block, this.meta);
    }

    @Override
    public void renderCubeLines(double x, double y, double z, float red, float green, float blue, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        LittleSlicedOrdinaryBox box = (LittleSlicedOrdinaryBox)this.box;
        LittleVec size = box.getSize();
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            EnumFacing facing = EnumFacing.field_82609_l[i];
            if (!box.slice.shouldRenderSide(facing, size)) continue;
            LittleSlicedOrdinaryRenderingCube.renderFaceLine(this.dynamicCube, facing, facing.func_176740_k() == box.slice.axis, red, green, blue, alpha);
        }
        GlStateManager.func_179121_F();
    }

    public static void renderFaceLine(LittleDynamicCube dynamicCube, EnumFacing facing, boolean isTraingle, float red, float green, float blue, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        Vector3f vec = new Vector3f();
        EnumFaceDirection face = EnumFaceDirection.func_179027_a((EnumFacing)facing);
        for (int i = 0; i < 4; ++i) {
            vec = dynamicCube.get(facing, face.func_179025_a(i), vec);
            if (i == 0) {
                bufferbuilder.func_181662_b((double)vec.x, (double)vec.y, (double)vec.z).func_181666_a(red, green, blue, 0.0f).func_181675_d();
            }
            bufferbuilder.func_181662_b((double)vec.x, (double)vec.y, (double)vec.z).func_181666_a(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    @Override
    public void renderCubePreview(double x, double y, double z, ILittleTile iTile) {
        Vec3d color = ColorUtils.IntToVec((int)this.color);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)((float)(Math.sin((double)System.nanoTime() / 2.0E8) * 0.2 + 0.5) * iTile.getPreviewAlphaFactor()));
        LittleSlicedOrdinaryBox box = (LittleSlicedOrdinaryBox)this.box;
        LittleVec size = box.getSize();
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            EnumFacing facing = EnumFacing.field_82609_l[i];
            if (!box.slice.shouldRenderSide(facing, size)) continue;
            LittleSlicedOrdinaryRenderingCube.renderFace(this.dynamicCube, facing, facing.func_176740_k() == box.slice.axis, box.slice);
        }
        GlStateManager.func_179121_F();
    }

    public static void renderFace(LittleDynamicCube cube, EnumFacing facing, boolean isTraingle, LittleSlice slice) {
        GL11.glBegin((int)9);
        Vec3i normal = facing.func_176730_m();
        GlStateManager.func_187432_a((float)normal.func_177958_n(), (float)normal.func_177956_o(), (float)normal.func_177952_p());
        Vector3f vec = new Vector3f();
        EnumFaceDirection face = EnumFaceDirection.func_179027_a((EnumFacing)facing);
        for (int i = 0; i < 4; ++i) {
            vec = cube.get(facing, face.func_179025_a(i), vec);
            GlStateManager.func_187435_e((float)vec.x, (float)vec.y, (float)vec.z);
        }
        GlStateManager.func_187437_J();
    }

    public boolean intersectsWithFace(EnumFacing facing, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, BlockPos offset) {
        switch (facing.func_176740_k()) {
            case X: {
                return maxY > this.dynamicCube.defaultCube.minY - (float)offset.func_177956_o() && minY < this.dynamicCube.defaultCube.maxY - (float)offset.func_177956_o() && maxZ > this.dynamicCube.defaultCube.minZ - (float)offset.func_177952_p() && minZ < this.dynamicCube.defaultCube.maxZ - (float)offset.func_177952_p();
            }
            case Y: {
                return maxX > this.dynamicCube.defaultCube.minX - (float)offset.func_177958_n() && minX < this.dynamicCube.defaultCube.maxX - (float)offset.func_177958_n() && maxZ > this.dynamicCube.defaultCube.minZ - (float)offset.func_177952_p() && minZ < this.dynamicCube.defaultCube.maxZ - (float)offset.func_177952_p();
            }
            case Z: {
                return maxX > this.dynamicCube.defaultCube.minX - (float)offset.func_177958_n() && minX < this.dynamicCube.defaultCube.maxX - (float)offset.func_177958_n() && maxY > this.dynamicCube.defaultCube.minY - (float)offset.func_177956_o() && minY < this.dynamicCube.defaultCube.maxY - (float)offset.func_177956_o();
            }
        }
        return false;
    }

    public List<BakedQuad> getBakedQuad(IBlockAccess world, @Nullable BlockPos pos, BlockPos offset, IBlockState state, IBakedModel blockModel, EnumFacing facing, BlockRenderLayer layer, long rand, boolean overrideTint, int defaultColor) {
        LittleSlicedOrdinaryBox box = (LittleSlicedOrdinaryBox)this.box;
        if (!box.slice.shouldRenderSide(facing, this.dynamicCube.defaultCube.getSize())) {
            return Collections.emptyList();
        }
        List blockQuads = this.getBakedQuad(world, blockModel, state, facing, pos, layer, rand);
        if (blockQuads.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        boolean isTraingle = facing.func_176740_k() == box.slice.axis;
        Vector3f vec = new Vector3f();
        int color = this.color != -1 ? this.color : defaultColor;
        for (int i = 0; i < blockQuads.size(); ++i) {
            float sizeV;
            float sizeU;
            BakedQuad oldQuad = (BakedQuad)blockQuads.get(i);
            int index = 0;
            int uvIndex = index + oldQuad.getFormat().func_177344_b(0) / 4;
            float tempMinX = Float.intBitsToFloat(oldQuad.func_178209_a()[index]);
            float tempMinY = Float.intBitsToFloat(oldQuad.func_178209_a()[index + 1]);
            float tempMinZ = Float.intBitsToFloat(oldQuad.func_178209_a()[index + 2]);
            float tempU = Float.intBitsToFloat(oldQuad.func_178209_a()[uvIndex]);
            float tempV = Float.intBitsToFloat(oldQuad.func_178209_a()[uvIndex + 1]);
            boolean uvInverted = false;
            index = 1 * oldQuad.getFormat().func_181719_f();
            uvIndex = index + oldQuad.getFormat().func_177344_b(0) / 4;
            uvInverted = tempMinX != Float.intBitsToFloat(oldQuad.func_178209_a()[index]) ? (tempU != Float.intBitsToFloat(oldQuad.func_178209_a()[uvIndex]) ? EnumFacing.Axis.X != RotationUtils.getUAxisFromFacing((EnumFacing)facing) : EnumFacing.Axis.X != RotationUtils.getVAxisFromFacing((EnumFacing)facing)) : (tempMinY != Float.intBitsToFloat(oldQuad.func_178209_a()[index + 1]) ? (tempU != Float.intBitsToFloat(oldQuad.func_178209_a()[uvIndex]) ? EnumFacing.Axis.Y != RotationUtils.getUAxisFromFacing((EnumFacing)facing) : EnumFacing.Axis.Y != RotationUtils.getVAxisFromFacing((EnumFacing)facing)) : (tempU != Float.intBitsToFloat(oldQuad.func_178209_a()[uvIndex]) ? EnumFacing.Axis.Z != RotationUtils.getUAxisFromFacing((EnumFacing)facing) : EnumFacing.Axis.Z != RotationUtils.getVAxisFromFacing((EnumFacing)facing)));
            index = 2 * oldQuad.getFormat().func_181719_f();
            float tempMaxX = Float.intBitsToFloat(oldQuad.func_178209_a()[index]);
            float tempMaxY = Float.intBitsToFloat(oldQuad.func_178209_a()[index + 1]);
            float tempMaxZ = Float.intBitsToFloat(oldQuad.func_178209_a()[index + 2]);
            float minX = Math.min(tempMinX, tempMaxX);
            float minY = Math.min(tempMinY, tempMaxY);
            float minZ = Math.min(tempMinZ, tempMaxZ);
            float maxX = Math.max(tempMinX, tempMaxX);
            float maxY = Math.max(tempMinY, tempMaxY);
            float maxZ = Math.max(tempMinZ, tempMaxZ);
            if (!this.intersectsWithFace(facing, minX, minY, minZ, maxX, maxY, maxZ, offset)) continue;
            float sizeX = maxX - minX;
            float sizeY = maxY - minY;
            float sizeZ = maxZ - minZ;
            CreativeBakedQuad quad = new CreativeBakedQuad((BakedQuad)blockQuads.get(i), (RenderCubeObject)this, color, overrideTint && (defaultColor == -1 || ((BakedQuad)blockQuads.get(i)).func_178212_b()) && color != -1, facing);
            uvIndex = quad.getFormat().func_177344_b(0) / 4;
            float u1 = Float.intBitsToFloat(quad.func_178209_a()[uvIndex]);
            float v1 = Float.intBitsToFloat(quad.func_178209_a()[uvIndex + 1]);
            uvIndex = 2 * quad.getFormat().func_181719_f() + quad.getFormat().func_177344_b(0) / 4;
            float u2 = Float.intBitsToFloat(quad.func_178209_a()[uvIndex]);
            float v2 = Float.intBitsToFloat(quad.func_178209_a()[uvIndex + 1]);
            if (uvInverted) {
                sizeU = RotationUtils.getVFromFacing((EnumFacing)facing, (float)tempMinX, (float)tempMinY, (float)tempMinZ) < RotationUtils.getVFromFacing((EnumFacing)facing, (float)tempMaxX, (float)tempMaxY, (float)tempMaxZ) ? u2 - u1 : u1 - u2;
                sizeV = RotationUtils.getUFromFacing((EnumFacing)facing, (float)tempMinX, (float)tempMinY, (float)tempMinZ) < RotationUtils.getUFromFacing((EnumFacing)facing, (float)tempMaxX, (float)tempMaxY, (float)tempMaxZ) ? v2 - v1 : v1 - v2;
            } else {
                sizeU = RotationUtils.getUFromFacing((EnumFacing)facing, (float)tempMinX, (float)tempMinY, (float)tempMinZ) < RotationUtils.getUFromFacing((EnumFacing)facing, (float)tempMaxX, (float)tempMaxY, (float)tempMaxZ) ? u2 - u1 : u1 - u2;
                sizeV = RotationUtils.getVFromFacing((EnumFacing)facing, (float)tempMinX, (float)tempMinY, (float)tempMinZ) < RotationUtils.getVFromFacing((EnumFacing)facing, (float)tempMaxX, (float)tempMaxY, (float)tempMaxZ) ? v2 - v1 : v1 - v2;
            }
            EnumFaceDirection direction = EnumFaceDirection.func_179027_a((EnumFacing)facing);
            for (int k = 0; k < 4; ++k) {
                float vOffset;
                float uOffset;
                EnumFaceDirection.VertexInformation vertex = direction.func_179025_a(k);
                index = k * quad.getFormat().func_181719_f();
                float x = facing.func_176740_k() == EnumFacing.Axis.X ? this.dynamicCube.defaultCube.getVertexInformationPosition(vertex.field_179184_a) - (float)offset.func_177958_n() : MathHelper.func_76131_a((float)(this.dynamicCube.defaultCube.getVertexInformationPosition(vertex.field_179184_a) - (float)offset.func_177958_n()), (float)minX, (float)maxX);
                float y = facing.func_176740_k() == EnumFacing.Axis.Y ? this.dynamicCube.defaultCube.getVertexInformationPosition(vertex.field_179182_b) - (float)offset.func_177956_o() : MathHelper.func_76131_a((float)(this.dynamicCube.defaultCube.getVertexInformationPosition(vertex.field_179182_b) - (float)offset.func_177956_o()), (float)minY, (float)maxY);
                float z = facing.func_176740_k() == EnumFacing.Axis.Z ? this.dynamicCube.defaultCube.getVertexInformationPosition(vertex.field_179183_c) - (float)offset.func_177952_p() : MathHelper.func_76131_a((float)(this.dynamicCube.defaultCube.getVertexInformationPosition(vertex.field_179183_c) - (float)offset.func_177952_p()), (float)minZ, (float)maxZ);
                vec.set(x, y, z);
                this.dynamicCube.sliceVector(facing, vec, offset);
                x = vec.x;
                y = vec.y;
                z = vec.z;
                float oldX = Float.intBitsToFloat(quad.func_178209_a()[index]);
                float oldY = Float.intBitsToFloat(quad.func_178209_a()[index + 1]);
                float oldZ = Float.intBitsToFloat(quad.func_178209_a()[index + 2]);
                quad.func_178209_a()[index] = Float.floatToIntBits(x + (float)offset.func_177958_n());
                quad.func_178209_a()[index + 1] = Float.floatToIntBits(y + (float)offset.func_177956_o());
                quad.func_178209_a()[index + 2] = Float.floatToIntBits(z + (float)offset.func_177952_p());
                if (this.keepVU) continue;
                uvIndex = index + quad.getFormat().func_177344_b(0) / 4;
                if (uvInverted) {
                    uOffset = (RotationUtils.getVFromFacing((EnumFacing)facing, (float)oldX, (float)oldY, (float)oldZ) - RotationUtils.getVFromFacing((EnumFacing)facing, (float)x, (float)y, (float)z)) / RotationUtils.getVFromFacing((EnumFacing)facing, (float)sizeX, (float)sizeY, (float)sizeZ) * sizeU;
                    vOffset = (RotationUtils.getUFromFacing((EnumFacing)facing, (float)oldX, (float)oldY, (float)oldZ) - RotationUtils.getUFromFacing((EnumFacing)facing, (float)x, (float)y, (float)z)) / RotationUtils.getUFromFacing((EnumFacing)facing, (float)sizeX, (float)sizeY, (float)sizeZ) * sizeV;
                } else {
                    uOffset = (RotationUtils.getUFromFacing((EnumFacing)facing, (float)oldX, (float)oldY, (float)oldZ) - RotationUtils.getUFromFacing((EnumFacing)facing, (float)x, (float)y, (float)z)) / RotationUtils.getUFromFacing((EnumFacing)facing, (float)sizeX, (float)sizeY, (float)sizeZ) * sizeU;
                    vOffset = (RotationUtils.getVFromFacing((EnumFacing)facing, (float)oldX, (float)oldY, (float)oldZ) - RotationUtils.getVFromFacing((EnumFacing)facing, (float)x, (float)y, (float)z)) / RotationUtils.getVFromFacing((EnumFacing)facing, (float)sizeX, (float)sizeY, (float)sizeZ) * sizeV;
                }
                quad.func_178209_a()[uvIndex] = Float.floatToRawIntBits(Float.intBitsToFloat(quad.func_178209_a()[uvIndex]) - uOffset);
                quad.func_178209_a()[uvIndex + 1] = Float.floatToRawIntBits(Float.intBitsToFloat(quad.func_178209_a()[uvIndex + 1]) - vOffset);
            }
            quads.add((BakedQuad)quad);
        }
        return quads;
    }
}

