/*
 * Decompiled with CFR 0.152.
 */
package com.animania.api.interfaces;

import com.animania.Animania;
import com.animania.api.interfaces.IAnimaniaAnimal;
import com.animania.config.AnimaniaConfig;
import java.util.Set;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.Fluid;

public interface IFoodEating
extends IAnimaniaAnimal {
    public DataParameter<Boolean> getHandFedParam();

    public DataParameter<Boolean> getFedParam();

    public DataParameter<Boolean> getWateredParam();

    public DataParameter<Boolean> getInteractedParam();

    default public void setFed(boolean fed) {
        DataParameter<Boolean> param = this.getFedParam();
        if (param != null) {
            EntityLivingBase e = (EntityLivingBase)this;
            if (fed) {
                this.setFedTimer(AnimaniaConfig.careAndFeeding.feedTimer + Animania.RANDOM.nextInt(100));
            }
            e.func_184212_Q().func_187227_b(param, (Object)fed);
        }
    }

    default public boolean getFed() {
        DataParameter<Boolean> param = this.getFedParam();
        if (param != null) {
            return this.getBoolFromDataManager(param);
        }
        return false;
    }

    default public void setWatered(boolean watered) {
        DataParameter<Boolean> param = this.getWateredParam();
        if (param != null) {
            EntityLivingBase e = (EntityLivingBase)this;
            if (watered) {
                this.setWaterTimer(AnimaniaConfig.careAndFeeding.waterTimer + Animania.RANDOM.nextInt(100));
            }
            e.func_184212_Q().func_187227_b(param, (Object)watered);
        }
    }

    default public boolean getWatered() {
        DataParameter<Boolean> param = this.getWateredParam();
        if (param != null) {
            return this.getBoolFromDataManager(param);
        }
        return false;
    }

    default public void setHandFed(boolean handfed) {
        DataParameter<Boolean> param = this.getHandFedParam();
        if (param != null) {
            ((Entity)this).func_184212_Q().func_187227_b(param, (Object)handfed);
        }
    }

    default public boolean getHandFed() {
        DataParameter<Boolean> param = this.getHandFedParam();
        if (param != null) {
            return this.getBoolFromDataManager(param);
        }
        return false;
    }

    default public void setInteracted(boolean interacted) {
        DataParameter<Boolean> param = this.getInteractedParam();
        if (param != null) {
            ((Entity)this).func_184212_Q().func_187227_b(this.getInteractedParam(), (Object)interacted);
        }
    }

    default public boolean getInteracted() {
        DataParameter<Boolean> param = this.getInteractedParam();
        if (param != null) {
            return this.getBoolFromDataManager(this.getInteractedParam());
        }
        return false;
    }

    default public float getHeadAnchorPointY(float partialTicks) {
        if (((Entity)this).func_184207_aI()) {
            return 0.0f;
        }
        int eatTimer = this.getEatTimer();
        float val = eatTimer <= 0 ? 0.0f : (eatTimer >= 4 && eatTimer <= 76 ? 1.0f : (eatTimer < 4 ? ((float)eatTimer - partialTicks) / 4.0f : -((float)(eatTimer - 80) - partialTicks) / 4.0f));
        return val;
    }

    default public float getHeadAngleX(float partialTicks) {
        if (((Entity)this).func_184207_aI()) {
            return 0.0f;
        }
        int eatTimer = this.getEatTimer();
        if (eatTimer > 4 && eatTimer <= 76) {
            float f = ((float)(eatTimer - 4) - partialTicks) / 24.0f;
            return 0.62831855f + 0.14660767f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return eatTimer > 0 ? 0.62831855f : ((Entity)this).field_70125_A * ((float)Math.PI / 180);
    }

    public Set<Item> getFoodItems();

    default public Fluid[] getFoodFluids() {
        return null;
    }

    default public void setLiquidFed(boolean liquidFed) {
    }

    default public Class[] getFoodBlocks() {
        return new Class[]{BlockCrops.class, IPlantable.class, BlockBush.class};
    }

    public int getEatTimer();

    public void setEatTimer(int var1);

    public int getFedTimer();

    public void setFedTimer(int var1);

    public int getWaterTimer();

    public void setWaterTimer(int var1);

    public int getDamageTimer();

    public void setDamageTimer(int var1);

    public int getHappyTimer();

    public void setHappyTimer(int var1);
}

