/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.cows;

import com.animania.api.data.AnimalContainer;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.AnimaniaType;
import com.animania.api.interfaces.IAnimaniaAnimalBase;
import com.animania.common.entities.cows.CowFriesian;
import com.animania.common.entities.cows.CowHolstein;
import com.animania.common.entities.cows.CowMooshroom;
import com.animania.common.entities.cows.CowType;
import com.animania.common.entities.cows.EntityBullBase;
import com.animania.common.entities.cows.EntityCalfBase;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.common.entities.generic.ai.GenericAIEatGrass;
import com.animania.common.entities.generic.ai.GenericAIFindFood;
import com.animania.common.entities.generic.ai.GenericAIFindSaltLick;
import com.animania.common.entities.generic.ai.GenericAIFindWater;
import com.animania.common.entities.generic.ai.GenericAILookIdle;
import com.animania.common.entities.generic.ai.GenericAIPanic;
import com.animania.common.entities.generic.ai.GenericAISleep;
import com.animania.common.entities.generic.ai.GenericAITempt;
import com.animania.common.entities.generic.ai.GenericAIWanderAvoidWater;
import com.animania.common.entities.generic.ai.GenericAIWatchClosest;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.items.ItemEntityEgg;
import com.animania.config.AnimaniaConfig;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimaniaCow
extends EntityCow
implements IAnimaniaAnimalBase {
    public static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])AnimaniaHelper.getItemArray(AnimaniaConfig.careAndFeeding.cowFood));
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaCow.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaCow.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaCow.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HANDFED = EntityDataManager.func_187226_a(EntityAnimaniaCow.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityAnimaniaCow.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SLEEPTIMER = EntityDataManager.func_187226_a(EntityAnimaniaCow.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> INTERACTED = EntityDataManager.func_187226_a(EntityAnimaniaCow.class, (DataSerializer)DataSerializers.field_187198_h);
    protected int happyTimer;
    public int blinkTimer;
    public int eatTimer;
    protected int fedTimer;
    protected int wateredTimer;
    protected int damageTimer;
    public GenericAIEatGrass<EntityAnimaniaCow> entityAIEatGrass;
    public CowType cowType;
    protected boolean mateable = false;
    protected EntityGender gender;

    public EntityAnimaniaCow(World worldIn) {
        super(worldIn);
        this.field_70714_bg.field_75782_a.clear();
        this.entityAIEatGrass = new GenericAIEatGrass<EntityAnimaniaCow>(this);
        this.field_70714_bg.func_75776_a(1, new GenericAIPanic<EntityAnimaniaCow>(this, 2.0));
        if (!AnimaniaConfig.gameRules.ambianceMode) {
            this.field_70714_bg.func_75776_a(2, new GenericAIFindWater<EntityAnimaniaCow>(this, 1.0, this.entityAIEatGrass, EntityAnimaniaCow.class));
            this.field_70714_bg.func_75776_a(3, new GenericAIFindFood<EntityAnimaniaCow>(this, 1.0, this.entityAIEatGrass, true));
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new GenericAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, new GenericAITempt<EntityAnimaniaCow>(this, 1.25, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, new GenericAITempt<EntityAnimaniaCow>(this, 1.25, Item.func_150898_a((Block)Blocks.field_150327_N), false));
        this.field_70714_bg.func_75776_a(6, new GenericAITempt<EntityAnimaniaCow>(this, 1.25, Item.func_150898_a((Block)Blocks.field_150328_O), false));
        this.field_70714_bg.func_75776_a(8, this.entityAIEatGrass);
        if (AnimaniaConfig.gameRules.animalsSleep) {
            this.field_70714_bg.func_75776_a(9, new GenericAISleep<EntityAnimaniaCow>(this, 0.8, AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.cowBed), AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.cowBed2), EntityAnimaniaCow.class));
        }
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new GenericAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, new GenericAILookIdle<EntityAnimaniaCow>(this));
        this.field_70714_bg.func_75776_a(12, new GenericAIFindSaltLick<EntityAnimaniaCow>(this, 1.0, this.entityAIEatGrass));
        this.field_70715_bh.func_75776_a(14, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        if (AnimaniaConfig.gameRules.animalsCanAttackOthers) {
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[]{EntityPlayer.class}));
        }
        this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
        this.func_110163_bv();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(INTERACTED, (Object)false);
        this.field_70180_af.func_187214_a(HANDFED, (Object)false);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(AGE, (Object)0);
    }

    protected void func_184651_r() {
    }

    protected void func_70619_bc() {
        this.eatTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null && !this.getSleeping()) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() - 0.2f);
        }
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected ResourceLocation func_184647_J() {
        return this instanceof EntityCalfBase ? null : (this.cowType.isPrime ? new ResourceLocation("animania", "cow_prime") : new ResourceLocation("animania", "cow_regular"));
    }

    public void func_70636_d() {
        GenericBehavior.livingUpdateCommon(this);
        if (this.func_95999_t().toLowerCase().trim().equals("purp") && (this instanceof CowFriesian.EntityCowFriesian || this instanceof CowFriesian.EntityBullFriesian || this instanceof CowHolstein.EntityCowHolstein || this instanceof CowHolstein.EntityBullHolstein || this instanceof CowFriesian.EntityCalfFriesian || this instanceof CowHolstein.EntityCalfHolstein)) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 4, 2, false, false));
            if (!this.func_70026_G() && !this.func_70090_H()) {
                this.func_70044_A();
            }
        }
        super.func_70636_d();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        EntityBullBase ebb;
        ItemStack stack = player.func_184586_b(hand);
        EntityPlayer entityplayer = player;
        if (this instanceof EntityBullBase && (ebb = (EntityBullBase)this).getFighting()) {
            return true;
        }
        if (stack != ItemStack.field_190927_a && AnimaniaHelper.isEmptyFluidContainer(stack)) {
            return true;
        }
        if (stack != ItemStack.field_190927_a && (this instanceof CowMooshroom.EntityCowMooshroom || this instanceof CowMooshroom.EntityBullMooshroom) && stack.func_77973_b() instanceof ItemShears && this.func_70874_b() >= 0) {
            this.func_70106_y();
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            if (!this.field_70170_p.field_72995_K) {
                EntityAnimaniaCow entitycow = null;
                entitycow = this instanceof CowMooshroom.EntityCowMooshroom ? new CowFriesian.EntityCowFriesian(this.field_70170_p) : new CowFriesian.EntityBullFriesian(this.field_70170_p);
                entitycow.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                entitycow.func_70606_j(this.func_110143_aJ());
                entitycow.field_70761_aq = this.field_70761_aq;
                if (this.func_145818_k_()) {
                    entitycow.func_96094_a(this.func_95999_t());
                }
                this.field_70170_p.func_72838_d((Entity)entitycow);
                for (int i = 0; i < 5; ++i) {
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v, new ItemStack((Block)Blocks.field_150337_Q)));
                }
                stack.func_77972_a(1, (EntityLivingBase)player);
                this.func_184185_a(SoundEvents.field_187784_dt, 1.0f, 1.0f);
            }
            return true;
        }
        return GenericBehavior.interactCommon(this, entityplayer, hand, this.entityAIEatGrass) ? true : super.func_184645_a(player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return this.mateable && stack != ItemStack.field_190927_a && this.isCowBreedingItem(stack.func_77973_b());
    }

    private boolean isCowBreedingItem(Item itemIn) {
        return TEMPTATION_ITEMS.contains(itemIn) || itemIn == Item.func_150898_a((Block)Blocks.field_150327_N) || itemIn == Item.func_150898_a((Block)Blocks.field_150328_O);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        GenericBehavior.writeCommonNBT(compound, this);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        GenericBehavior.readCommonNBT(compound, this);
    }

    @Override
    public Item getSpawnEgg() {
        return ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(this.cowType, this.gender));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getSpawnEgg());
    }

    @Override
    public int getPrimaryEggColor() {
        return 0;
    }

    @Override
    public int getSecondaryEggColor() {
        return 0;
    }

    @Override
    public EntityGender getEntityGender() {
        return this.gender;
    }

    @Override
    public void setSleepingPos(BlockPos pos) {
    }

    @Override
    public BlockPos getSleepingPos() {
        return null;
    }

    @Override
    public Set<Item> getFoodItems() {
        return TEMPTATION_ITEMS;
    }

    @Override
    public int getBlinkTimer() {
        return this.blinkTimer;
    }

    @Override
    public void setBlinkTimer(int i) {
        this.blinkTimer = i;
    }

    @Override
    public int getEatTimer() {
        return this.eatTimer;
    }

    @Override
    public void setEatTimer(int i) {
        this.eatTimer = i;
    }

    @Override
    public int getFedTimer() {
        return this.fedTimer;
    }

    @Override
    public void setFedTimer(int i) {
        this.fedTimer = i;
    }

    @Override
    public int getWaterTimer() {
        return this.wateredTimer;
    }

    @Override
    public void setWaterTimer(int i) {
        this.wateredTimer = i;
    }

    @Override
    public int getDamageTimer() {
        return this.damageTimer;
    }

    @Override
    public void setDamageTimer(int i) {
        this.damageTimer = i;
    }

    @Override
    public int getHappyTimer() {
        return this.happyTimer;
    }

    @Override
    public void setHappyTimer(int i) {
        this.happyTimer = i;
    }

    @Override
    public AnimaniaType getAnimalType() {
        return this.cowType;
    }

    @Override
    public DataParameter<Boolean> getHandFedParam() {
        return HANDFED;
    }

    @Override
    public DataParameter<Boolean> getFedParam() {
        return FED;
    }

    @Override
    public DataParameter<Boolean> getWateredParam() {
        return WATERED;
    }

    @Override
    public DataParameter<Boolean> getInteractedParam() {
        return INTERACTED;
    }

    @Override
    public DataParameter<Integer> getAgeParam() {
        return AGE;
    }

    @Override
    public DataParameter<Boolean> getSleepingParam() {
        return SLEEPING;
    }

    @Override
    public DataParameter<Float> getSleepTimerParam() {
        return SLEEPTIMER;
    }
}

