/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.cows;

import com.animania.Animania;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.IMateable;
import com.animania.api.interfaces.ISterilizable;
import com.animania.common.ModSoundEvents;
import com.animania.common.entities.cows.EntityAnimaniaCow;
import com.animania.common.entities.cows.EntityCalfBase;
import com.animania.common.entities.cows.EntityCowBase;
import com.animania.common.entities.cows.ai.EntityAIAttackMeleeBulls;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.common.entities.generic.ai.GenericAIMate;
import com.animania.compat.top.providers.entity.TOPInfoProviderMateable;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBullBase
extends EntityAnimaniaCow
implements TOPInfoProviderMateable,
IMateable,
ISterilizable {
    protected static final DataParameter<Boolean> FIGHTING = EntityDataManager.func_187226_a(EntityBullBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> STERILIZED = EntityDataManager.func_187226_a(EntityBullBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntityBullBase.class, (DataSerializer)DataSerializers.field_187203_m);

    public EntityBullBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.6f, 1.8f);
        this.field_70130_N = 1.6f;
        this.field_70131_O = 1.8f;
        this.gender = EntityGender.MALE;
        this.field_70138_W = 1.1f;
        this.mateable = true;
        if (AnimaniaConfig.gameRules.animalsCanAttackOthers && !this.getSterilized()) {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackMeleeBulls(this, 1.8, false));
        }
        if (!this.getSterilized()) {
            this.field_70714_bg.func_75776_a(3, new GenericAIMate(this, 1.0, EntityCowBase.class, EntityCalfBase.class, EntityAnimaniaCow.class));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIGHTING, (Object)false);
        this.field_70180_af.func_187214_a(STERILIZED, (Object)false);
        this.field_70180_af.func_187214_a(MATE_UNIQUE_ID, (Object)Optional.absent());
    }

    public void func_146082_f(EntityPlayer player) {
        if (!this.getFighting() && !this.getSleeping()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)18);
        }
    }

    public boolean getFighting() {
        return this.getBoolFromDataManager(FIGHTING);
    }

    public void setFighting(boolean fighting) {
        this.field_70180_af.func_187227_b(FIGHTING, (Object)fighting);
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.getSleeping()) {
            this.setSleeping(false);
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = false;
        if (this.func_70685_l(entityIn) && this.func_70032_d(entityIn) <= 2.0f) {
            flag = entityIn.func_70097_a((DamageSource)new EntityDamageSource("bull", (Entity)this), 5.0f);
            if (flag) {
                this.func_174815_a((EntityLivingBase)this, entityIn);
            }
            if (entityIn instanceof EntityPlayer) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, 1.0f, (this.field_70165_t - entityIn.field_70165_t) / 2.0, (this.field_70161_v - entityIn.field_70161_v) / 2.0);
            }
        }
        return flag;
    }

    protected SoundEvent func_184639_G() {
        return GenericBehavior.getAmbientSound(this, ModSoundEvents.bullMoo1, ModSoundEvents.bullMoo2, ModSoundEvents.bullMoo3, ModSoundEvents.bullMoo4, ModSoundEvents.bullMoo5, ModSoundEvents.bullMoo6, ModSoundEvents.bullMoo7, ModSoundEvents.bullMoo8, ModSoundEvents.moo4, ModSoundEvents.moo8, ModSoundEvents.moo4, ModSoundEvents.moo8);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return GenericBehavior.getRandomSound(ModSoundEvents.angryBull1, ModSoundEvents.angryBull2, ModSoundEvents.angryBull3);
    }

    protected SoundEvent func_184615_bR() {
        return Animania.RANDOM.nextBoolean() ? ModSoundEvents.cowDeath1 : ModSoundEvents.cowDeath2;
    }

    @Override
    public void func_70636_d() {
        GenericBehavior.livingUpdateMateable(this, EntityCowBase.class);
        super.func_70636_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getHeadAnchorPointY(float p_70894_1_) {
        if (this.getFighting()) {
            return 0.0f;
        }
        return super.getHeadAnchorPointY(p_70894_1_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getHeadAngleX(float p_70890_1_) {
        if (this.getFighting()) {
            return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
        }
        return super.getHeadAngleX(p_70890_1_);
    }

    public EntityBullBase createChild(EntityAgeable p_90011_1_) {
        return null;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Fighting", this.getFighting());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setFighting(compound.func_74767_n("Fighting"));
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (player.func_70093_af() && this.getMateUniqueId() != null) {
            probeInfo.text(I18n.func_74838_a((String)"text.waila.mated"));
        }
        TOPInfoProviderMateable.super.addProbeInfo(mode, probeInfo, player, world, entity, data);
    }

    @Override
    public DataParameter<Boolean> getSterilizedParam() {
        return STERILIZED;
    }

    @Override
    public void sterilize() {
        Iterator it = this.field_70714_bg.field_75782_a.iterator();
        while (it.hasNext()) {
            EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)it.next();
            EntityAIBase ai = entry.field_75733_a;
            if (!(ai instanceof GenericAIMate) && !(ai instanceof EntityAIAttackMeleeBulls)) continue;
            entry.field_188524_c = false;
            ai.func_75251_c();
            it.remove();
        }
        this.setSterilized(true);
    }

    @Override
    public DataParameter<Optional<UUID>> getMateUniqueIdParam() {
        return MATE_UNIQUE_ID;
    }
}

