/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.goats;

import com.animania.api.data.AnimalContainer;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.AnimaniaType;
import com.animania.api.interfaces.IAnimaniaAnimalBase;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.common.entities.generic.ai.GenericAIAvoidEntity;
import com.animania.common.entities.generic.ai.GenericAIEatGrass;
import com.animania.common.entities.generic.ai.GenericAIFindFood;
import com.animania.common.entities.generic.ai.GenericAIFindSaltLick;
import com.animania.common.entities.generic.ai.GenericAIFindWater;
import com.animania.common.entities.generic.ai.GenericAILookIdle;
import com.animania.common.entities.generic.ai.GenericAIPanic;
import com.animania.common.entities.generic.ai.GenericAISleep;
import com.animania.common.entities.generic.ai.GenericAITempt;
import com.animania.common.entities.generic.ai.GenericAIWanderAvoidWater;
import com.animania.common.entities.generic.ai.GenericAIWatchClosest;
import com.animania.common.entities.goats.EntityKidBase;
import com.animania.common.entities.goats.GoatAngora;
import com.animania.common.entities.goats.GoatType;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.items.ItemEntityEgg;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimaniaGoat
extends EntitySheep
implements IAnimaniaAnimalBase {
    public static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])AnimaniaHelper.getItemArray(AnimaniaConfig.careAndFeeding.goatFood));
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> RIVAL_UNIQUE_ID = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Boolean> SHEARED = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> SHEARED_TIMER = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> SPOOKED = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SPOOKED_TIMER = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> HANDFED = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SLEEPTIMER = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> INTERACTED = EntityDataManager.func_187226_a(EntityAnimaniaGoat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected int happyTimer;
    public int blinkTimer;
    public int eatTimer;
    protected int fedTimer;
    protected int wateredTimer;
    protected int damageTimer;
    public GoatType goatType;
    public GenericAIEatGrass<EntityAnimaniaGoat> field_146087_bs;
    protected boolean mateable = false;
    protected boolean headbutting = false;
    protected EntityGender gender;
    private boolean hasRemovedBOP;

    public EntityAnimaniaGoat(World worldIn) {
        super(worldIn);
        this.field_70714_bg.field_75782_a.clear();
        this.field_146087_bs = new GenericAIEatGrass<EntityAnimaniaGoat>(this);
        this.field_70714_bg.func_75776_a(0, new GenericAIPanic<EntityAnimaniaGoat>(this, 1.4));
        if (!AnimaniaConfig.gameRules.ambianceMode) {
            this.field_70714_bg.func_75776_a(2, new GenericAIFindWater<EntityAnimaniaGoat>(this, 1.0, this.field_146087_bs, EntityAnimaniaGoat.class));
            this.field_70714_bg.func_75776_a(3, new GenericAIFindFood<EntityAnimaniaGoat>(this, 1.0, this.field_146087_bs, true));
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new GenericAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, new GenericAITempt<EntityAnimaniaGoat>(this, 1.25, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(8, this.field_146087_bs);
        this.field_70714_bg.func_75776_a(9, new GenericAIAvoidEntity<EntityWolf>((EntityCreature)this, EntityWolf.class, 20.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new GenericAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, new GenericAILookIdle<EntityAnimaniaGoat>(this));
        this.field_70714_bg.func_75776_a(12, new GenericAIFindSaltLick<EntityAnimaniaGoat>(this, 1.0, this.field_146087_bs));
        if (AnimaniaConfig.gameRules.animalsSleep) {
            this.field_70714_bg.func_75776_a(10, new GenericAISleep<EntityAnimaniaGoat>(this, 0.8, AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.goatBed), AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.goatBed2), EntityAnimaniaGoat.class));
        }
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
        this.func_70107_b(0.0, 0.0, 0.0);
        this.func_110163_bv();
    }

    protected void func_184651_r() {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        float f = this.field_70130_N / 2.0f;
        float f1 = this.field_70131_O;
        this.func_174826_a(new AxisAlignedBB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(HANDFED, (Object)false);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(RIVAL_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SHEARED, (Object)false);
        this.field_70180_af.func_187214_a(SHEARED_TIMER, (Object)(AnimaniaConfig.careAndFeeding.woolRegrowthTimer + this.field_70146_Z.nextInt(500)));
        this.field_70180_af.func_187214_a(SPOOKED, (Object)false);
        this.field_70180_af.func_187214_a(SPOOKED_TIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(AGE, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(INTERACTED, (Object)false);
    }

    protected ResourceLocation func_184647_J() {
        return this instanceof EntityKidBase ? null : (this.goatType.isPrime ? new ResourceLocation("animania", "goat_prime") : new ResourceLocation("animania", "goat_regular"));
    }

    public void setSpooked(boolean spooked) {
        this.field_70180_af.func_187227_b(SPOOKED, (Object)spooked);
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return this.mateable && stack != ItemStack.field_190927_a && this.isGoatBreedingItem(stack.func_77973_b());
    }

    private boolean isGoatBreedingItem(Item itemIn) {
        return TEMPTATION_ITEMS.contains(itemIn) || itemIn == Item.func_150898_a((Block)Blocks.field_150327_N) || itemIn == Item.func_150898_a((Block)Blocks.field_150328_O);
    }

    public boolean getSpooked() {
        return this.getBoolFromDataManager(SPOOKED);
    }

    public Float getSpookedTimer() {
        return Float.valueOf(this.getFloatFromDataManager(SPOOKED_TIMER));
    }

    @Override
    public DataParameter<Integer> getAgeParam() {
        return AGE;
    }

    public void setSpookedTimer(Float timer) {
        this.field_70180_af.func_187227_b(SPOOKED_TIMER, (Object)Float.valueOf(timer.floatValue()));
    }

    @Override
    public DataParameter<Boolean> getSleepingParam() {
        return SLEEPING;
    }

    @Override
    public DataParameter<Float> getSleepTimerParam() {
        return SLEEPTIMER;
    }

    @Override
    public DataParameter<Boolean> getHandFedParam() {
        return HANDFED;
    }

    @Override
    public DataParameter<Boolean> getFedParam() {
        return FED;
    }

    protected void func_70619_bc() {
        this.eatTimer = this.field_146087_bs.getEatingGrassTimer();
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Items.field_151116_aA;
    }

    public void func_70636_d() {
        if (!this.hasRemovedBOP && Loader.isModLoaded((String)"biomesoplenty")) {
            Iterator it = this.field_70714_bg.field_75782_a.iterator();
            while (it.hasNext()) {
                EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)it.next();
                EntityAIBase ai = entry.field_75733_a;
                try {
                    if (!Class.forName("biomesoplenty.common.entities.ai.EntityAIEatBOPGrass").isInstance(ai)) continue;
                    entry.field_188524_c = false;
                    ai.func_75251_c();
                    it.remove();
                }
                catch (Exception exception) {}
            }
            this.hasRemovedBOP = true;
        }
        if (this.getSpooked()) {
            if (this.getSpookedTimer().floatValue() == 1.0f) {
                this.func_70637_d(true);
            } else {
                this.func_70637_d(false);
            }
            this.func_70661_as().func_75499_g();
            this.func_94061_f(true);
            this.setSpookedTimer(Float.valueOf(this.getSpookedTimer().floatValue() - 0.01f));
            if (this.getSpookedTimer().floatValue() <= 0.2f && this.getSpookedTimer().floatValue() > 0.1f) {
                this.func_70637_d(true);
            } else if (this.getSpookedTimer().floatValue() <= 0.0f) {
                this.setSpooked(false);
                this.setSpookedTimer(Float.valueOf(0.0f));
                this.func_94061_f(false);
                this.func_70637_d(false);
            }
        }
        GenericBehavior.livingUpdateCommon(this);
        boolean sheared = this.func_70892_o();
        if (sheared) {
            int shearedTimer = this.getWoolRegrowthTimer();
            this.setWoolRegrowthTimer(--shearedTimer);
            if (shearedTimer < 0) {
                this.func_70893_e(false);
            }
        }
        super.func_70636_d();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        EntityPlayer entityplayer = player;
        if (stack.func_77973_b() instanceof ItemShears && !this.func_70892_o() && !this.func_70631_g_() && (this instanceof GoatAngora.EntityBuckAngora || this instanceof GoatAngora.EntityDoeAngora)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70893_e(true);
                int i = 1 + this.field_70146_Z.nextInt(2);
                for (int j = 0; j < i; ++j) {
                    EntityItem entityitem = this.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1), 1.0f);
                    entityitem.field_70181_x += (double)(this.field_70146_Z.nextFloat() * 0.05f);
                    entityitem.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                    entityitem.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                }
            }
            player.func_184609_a(hand);
            stack.func_77972_a(1, (EntityLivingBase)player);
            this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
            if (this.getSleeping()) {
                this.setSleeping(false);
            }
            return true;
        }
        if (stack.func_77973_b() instanceof ItemDye) {
            return true;
        }
        if (stack.func_77973_b() instanceof ItemShears) {
            return true;
        }
        return GenericBehavior.interactCommon(this, entityplayer, hand, this.field_146087_bs) ? true : super.func_184645_a(player, hand);
    }

    public void func_70615_aA() {
    }

    public void func_146082_f(EntityPlayer player) {
        if (!this.getSleeping()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)18);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Sheared", this.func_70892_o());
        compound.func_74757_a("Spooked", this.getSpooked());
        GenericBehavior.writeCommonNBT(compound, this);
    }

    public boolean func_70892_o() {
        return this.getBoolFromDataManager(SHEARED);
    }

    public void func_70893_e(boolean sheared) {
        if (sheared) {
            this.field_70180_af.func_187227_b(SHEARED, (Object)true);
            this.setWoolRegrowthTimer(AnimaniaConfig.careAndFeeding.woolRegrowthTimer + this.field_70146_Z.nextInt(500));
        } else {
            this.field_70180_af.func_187227_b(SHEARED, (Object)false);
        }
    }

    public int getWoolRegrowthTimer() {
        return this.getIntFromDataManager(SHEARED_TIMER);
    }

    public void setWoolRegrowthTimer(int time) {
        this.field_70180_af.func_187227_b(SHEARED_TIMER, (Object)time);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_70893_e(compound.func_74767_n("Sheared"));
        this.setSpooked(compound.func_74767_n("Spooked"));
        GenericBehavior.readCommonNBT(compound, this);
    }

    public EntityAnimaniaGoat createChild(EntityAgeable ageable) {
        return null;
    }

    @Override
    public Item getSpawnEgg() {
        return ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(this.goatType, this.gender));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getSpawnEgg());
    }

    @Override
    public int getPrimaryEggColor() {
        return 0;
    }

    @Override
    public int getSecondaryEggColor() {
        return 0;
    }

    @Override
    public EntityGender getEntityGender() {
        return this.gender;
    }

    @Override
    public Set<Item> getFoodItems() {
        return TEMPTATION_ITEMS;
    }

    @Override
    public void setSleepingPos(BlockPos pos) {
    }

    @Override
    public BlockPos getSleepingPos() {
        return null;
    }

    @Override
    public int getBlinkTimer() {
        return this.blinkTimer;
    }

    @Override
    public void setBlinkTimer(int i) {
        this.blinkTimer = i;
    }

    @Override
    public int getEatTimer() {
        return this.eatTimer;
    }

    @Override
    public void setEatTimer(int i) {
        this.eatTimer = i;
    }

    @Override
    public int getFedTimer() {
        return this.fedTimer;
    }

    @Override
    public void setFedTimer(int i) {
        this.fedTimer = i;
    }

    @Override
    public DataParameter<Boolean> getInteractedParam() {
        return INTERACTED;
    }

    @Override
    public int getWaterTimer() {
        return this.wateredTimer;
    }

    @Override
    public void setWaterTimer(int i) {
        this.wateredTimer = i;
    }

    @Override
    public int getDamageTimer() {
        return this.damageTimer;
    }

    @Override
    public void setDamageTimer(int i) {
        this.damageTimer = i;
    }

    @Override
    public int getHappyTimer() {
        return this.happyTimer;
    }

    @Override
    public void setHappyTimer(int i) {
        this.happyTimer = i;
    }

    @Override
    public AnimaniaType getAnimalType() {
        return this.goatType;
    }

    @Override
    public DataParameter<Boolean> getWateredParam() {
        return WATERED;
    }
}

