/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.goats.ai;

import com.animania.Animania;
import com.animania.common.entities.goats.EntityAnimaniaGoat;
import com.animania.common.entities.goats.EntityBuckBase;
import com.animania.common.entities.goats.EntityDoeBase;
import com.animania.common.entities.goats.EntityKidBase;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.config.AnimaniaConfig;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.world.World;

public class EntityAIButtHeadsGoats
extends EntityAIBase {
    private final EntityAnimaniaGoat theAnimal;
    World theWorld;
    private EntityAnimal targetMate;
    int fightTimer;
    double moveSpeed;
    private int delayCounter;

    public EntityAIButtHeadsGoats(EntityAnimaniaGoat animal, double speedIn) {
        this.theAnimal = animal;
        this.theWorld = animal.field_70170_p;
        this.moveSpeed = speedIn;
        this.func_75248_a(3);
        this.fightTimer = 100 + Animania.RANDOM.nextInt(50);
        this.delayCounter = 0;
    }

    public boolean func_75250_a() {
        ++this.delayCounter;
        if (this.delayCounter > AnimaniaConfig.gameRules.ticksBetweenAIFirings * 20) {
            if (this.theAnimal instanceof EntityDoeBase || this.theAnimal instanceof EntityKidBase) {
                return false;
            }
            if (!this.theAnimal.field_70170_p.func_72935_r() || this.theAnimal.getSleeping()) {
                this.delayCounter = 0;
                return false;
            }
            this.targetMate = this.getNearbyRival();
            if (this.targetMate != null && Animania.RANDOM.nextInt(20) == 0) {
                this.delayCounter = 0;
                this.func_75251_c();
                return false;
            }
            EntityBuckBase thisEntity = (EntityBuckBase)this.theAnimal;
            return this.targetMate != null && thisEntity.getFighting();
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.targetMate != null) {
            return this.targetMate.func_70089_S();
        }
        return false;
    }

    public void func_75251_c() {
        this.targetMate = null;
    }

    public void func_75246_d() {
        EntityBuckBase thisEntity = (EntityBuckBase)this.theAnimal;
        if (thisEntity.getFighting()) {
            this.theAnimal.func_70671_ap().func_75651_a((Entity)this.targetMate, 10.0f, (float)this.theAnimal.func_70646_bf());
            this.theAnimal.func_70661_as().func_75497_a((Entity)this.targetMate, this.moveSpeed);
        } else {
            thisEntity.func_70661_as().func_75499_g();
        }
    }

    private EntityAnimal getNearbyRival() {
        if (this.theAnimal instanceof EntityBuckBase) {
            EntityBuckBase thisEntity = (EntityBuckBase)this.theAnimal;
            EntityBuckBase foundEntity = null;
            List<EntityBuckBase> entities = AnimaniaHelper.getEntitiesInRange(EntityBuckBase.class, 10.0, this.theAnimal.field_70170_p, (Entity)this.theAnimal);
            if (entities != null) {
                for (int k = 0; k < entities.size(); ++k) {
                    EntityBuckBase entity = entities.get(k);
                    if (thisEntity.getRivalUniqueId() == null && entity.getRivalUniqueId() == null && thisEntity != entity) {
                        foundEntity = entity;
                        foundEntity.setRivalUniqueId(thisEntity.getPersistentID());
                        thisEntity.setRivalUniqueId(foundEntity.getPersistentID());
                        thisEntity.setFighting(true);
                        foundEntity.setFighting(true);
                        thisEntity.func_70624_b((EntityLivingBase)foundEntity);
                        foundEntity.func_70624_b((EntityLivingBase)thisEntity);
                        k = entities.size();
                        break;
                    }
                    if (thisEntity.getRivalUniqueId() == null || thisEntity.getRivalUniqueId() != entity.getPersistentID() || thisEntity == entity) continue;
                    foundEntity = entity;
                    foundEntity.setRivalUniqueId(thisEntity.getPersistentID());
                    thisEntity.setRivalUniqueId(foundEntity.getPersistentID());
                    thisEntity.func_70624_b((EntityLivingBase)foundEntity);
                    foundEntity.func_70624_b((EntityLivingBase)thisEntity);
                    k = entities.size();
                    break;
                }
            }
            --this.fightTimer;
            if (foundEntity != null) {
                if (this.fightTimer < 0 && thisEntity.getFighting()) {
                    this.fightTimer = 100 + Animania.RANDOM.nextInt(50);
                    this.targetMate = null;
                    thisEntity.setFighting(false);
                    foundEntity.setFighting(false);
                    foundEntity.setRivalUniqueId(null);
                    thisEntity.setRivalUniqueId(null);
                    thisEntity.func_70624_b(null);
                    foundEntity.func_70624_b(null);
                    this.delayCounter = 0;
                    return null;
                }
                thisEntity.func_70671_ap().func_75651_a(foundEntity, 10.0f, (float)thisEntity.func_70646_bf());
                thisEntity.func_70661_as().func_75497_a((Entity)foundEntity, this.moveSpeed);
                foundEntity.func_70671_ap().func_75651_a((Entity)thisEntity, 10.0f, (float)foundEntity.func_70646_bf());
                foundEntity.func_70661_as().func_75497_a((Entity)thisEntity, this.moveSpeed);
                return null;
            }
            if (foundEntity == null || this.fightTimer < 0) {
                this.fightTimer = 100 + Animania.RANDOM.nextInt(50);
                this.targetMate = null;
                thisEntity.setFighting(false);
                thisEntity.setRivalUniqueId(null);
                thisEntity.func_70624_b(null);
                this.delayCounter = 0;
                return null;
            }
        }
        return null;
    }
}

