/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.rodents;

import com.animania.Animania;
import com.animania.api.data.AnimalContainer;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.AnimaniaType;
import com.animania.api.interfaces.IAnimaniaAnimalBase;
import com.animania.common.ModSoundEvents;
import com.animania.common.capabilities.CapabilityRefs;
import com.animania.common.capabilities.ICapabilityPlayer;
import com.animania.common.entities.amphibians.EntityAmphibian;
import com.animania.common.entities.amphibians.EntityFrogs;
import com.animania.common.entities.amphibians.EntityToad;
import com.animania.common.entities.chickens.ChickenLeghorn;
import com.animania.common.entities.chickens.ChickenOrpington;
import com.animania.common.entities.chickens.ChickenPlymouthRock;
import com.animania.common.entities.chickens.ChickenRhodeIslandRed;
import com.animania.common.entities.chickens.ChickenWyandotte;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.common.entities.generic.ai.GenericAIEatGrass;
import com.animania.common.entities.generic.ai.GenericAIFindFood;
import com.animania.common.entities.generic.ai.GenericAIFindWater;
import com.animania.common.entities.generic.ai.GenericAIFollowOwner;
import com.animania.common.entities.generic.ai.GenericAILookIdle;
import com.animania.common.entities.generic.ai.GenericAINearestAttackableTarget;
import com.animania.common.entities.generic.ai.GenericAIPanic;
import com.animania.common.entities.generic.ai.GenericAISleep;
import com.animania.common.entities.generic.ai.GenericAISwimmingSmallCreatures;
import com.animania.common.entities.generic.ai.GenericAITempt;
import com.animania.common.entities.generic.ai.GenericAIWanderAvoidWater;
import com.animania.common.entities.generic.ai.GenericAIWatchClosest;
import com.animania.common.entities.rodents.FerretType;
import com.animania.common.entities.rodents.ai.EntityAIFerretFindNests;
import com.animania.common.entities.rodents.ai.EntityAIRodentEat;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.items.ItemEntityEgg;
import com.animania.compat.top.providers.entity.TOPInfoProviderRodent;
import com.animania.config.AnimaniaConfig;
import com.animania.network.client.CapSyncPacket;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFerretBase
extends EntityTameable
implements TOPInfoProviderRodent,
IAnimaniaAnimalBase {
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityFerretBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityFerretBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> RIDING = EntityDataManager.func_187226_a(EntityFerretBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityFerretBase.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityFerretBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SLEEPTIMER = EntityDataManager.func_187226_a(EntityFerretBase.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> INTERACTED = EntityDataManager.func_187226_a(EntityFerretBase.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])AnimaniaHelper.getItemArray(AnimaniaConfig.careAndFeeding.ferretFood));
    protected int fedTimer;
    protected int wateredTimer;
    protected int happyTimer;
    protected int tamedTimer;
    public int blinkTimer;
    public int eatTimer;
    public GenericAIEatGrass<EntityFerretBase> entityAIEatGrass;
    protected int damageTimer;
    protected FerretType type;

    public EntityFerretBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.75f, 0.4f);
        this.field_70138_W = 1.1f;
        this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer * 2 + this.field_70146_Z.nextInt(200);
        this.happyTimer = 60;
        this.tamedTimer = 120;
        this.blinkTimer = 70 + this.field_70146_Z.nextInt(70);
        this.func_110163_bv();
        this.entityAIEatGrass = new GenericAIEatGrass<EntityFerretBase>(this, false);
        this.field_70714_bg.func_75776_a(11, this.entityAIEatGrass);
        this.initAI();
    }

    protected void initAI() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new GenericAISwimmingSmallCreatures((EntityLiving)this));
        if (!AnimaniaConfig.gameRules.ambianceMode) {
            this.field_70714_bg.func_75776_a(1, new GenericAIFindWater<EntityFerretBase>(this, 1.0, this.entityAIEatGrass, EntityFerretBase.class, true));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFerretFindNests((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(3, new GenericAIFindFood<EntityFerretBase>(this, 1.0, this.entityAIEatGrass, false));
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.2f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(7, new GenericAIFollowOwner<EntityFerretBase>(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(8, new GenericAIPanic<EntityFerretBase>(this, 1.5));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIRodentEat((EntityLiving)this));
        this.field_70714_bg.func_75776_a(10, new GenericAITempt<EntityFerretBase>(this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new GenericAIWanderAvoidWater((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new GenericAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(14, new GenericAILookIdle<EntityFerretBase>(this));
        if (AnimaniaConfig.gameRules.animalsSleep) {
            this.field_70714_bg.func_75776_a(15, new GenericAISleep<EntityFerretBase>(this, 0.8, AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.ferretBed), AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.ferretBed2), EntityFerretBase.class));
        }
        if (AnimaniaConfig.gameRules.animalsCanAttackOthers) {
            this.field_70715_bh.func_75776_a(1, new GenericAINearestAttackableTarget<ChickenLeghorn.EntityChickLeghorn>((EntityCreature)this, ChickenLeghorn.EntityChickLeghorn.class, false));
            this.field_70715_bh.func_75776_a(2, new GenericAINearestAttackableTarget<ChickenOrpington.EntityChickOrpington>((EntityCreature)this, ChickenOrpington.EntityChickOrpington.class, false));
            this.field_70715_bh.func_75776_a(3, new GenericAINearestAttackableTarget<ChickenPlymouthRock.EntityChickPlymouthRock>((EntityCreature)this, ChickenPlymouthRock.EntityChickPlymouthRock.class, false));
            this.field_70715_bh.func_75776_a(4, new GenericAINearestAttackableTarget<ChickenRhodeIslandRed.EntityChickRhodeIslandRed>((EntityCreature)this, ChickenRhodeIslandRed.EntityChickRhodeIslandRed.class, false));
            this.field_70715_bh.func_75776_a(5, new GenericAINearestAttackableTarget<ChickenWyandotte.EntityChickWyandotte>((EntityCreature)this, ChickenWyandotte.EntityChickWyandotte.class, false));
            this.field_70715_bh.func_75776_a(6, new GenericAINearestAttackableTarget<EntitySilverfish>((EntityCreature)this, EntitySilverfish.class, false));
            this.field_70715_bh.func_75776_a(7, new GenericAINearestAttackableTarget<EntityFrogs>((EntityCreature)this, EntityFrogs.class, false));
            this.field_70715_bh.func_75776_a(8, new GenericAINearestAttackableTarget<EntityToad>((EntityCreature)this, EntityToad.class, false));
        }
        this.field_70715_bh.func_75776_a(9, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(0.5);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        this.setFed(true);
        if (!this.func_70909_n()) {
            this.func_184754_b(player.getPersistentID());
            this.func_70903_f(true);
            this.func_146082_f(player);
        }
        this.func_70904_g(false);
        this.entityAIEatGrass.func_75249_e();
        if (!player.field_71075_bZ.field_75098_d && stack != ItemStack.field_190927_a) {
            stack.func_190920_e(stack.func_190916_E() - 1);
        }
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    protected void func_70619_bc() {
        this.eatTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("animania", "ferret");
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ICapabilityPlayer props;
        ItemStack stack = player.func_184586_b(hand);
        EntityPlayer entityplayer = player;
        if (stack == ItemStack.field_190927_a && this.func_70909_n() && player.func_70093_af() && !this.getSleeping() && !(props = CapabilityRefs.getPlayerCaps(player)).isCarrying()) {
            props.setAnimal(this.func_189511_e(new NBTTagCompound()));
            props.setCarrying(true);
            props.setType(EntityList.func_191301_a((Entity)this).func_110623_a());
            this.func_70106_y();
            player.func_184609_a(EnumHand.MAIN_HAND);
            Animania.network.sendToAllAround((IMessage)new CapSyncPacket(props, player.func_145782_y()), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.getDimension(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), 64.0));
            return true;
        }
        return GenericBehavior.interactCommon(this, player, hand, this.entityAIEatGrass) ? true : super.func_184645_a(player, hand);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        if (entityIn instanceof EntityAmphibian) {
            this.setFed(true);
        }
        if (entityIn instanceof EntityPlayer) {
            ((EntityLivingBase)entityIn).func_70653_a((Entity)this, 0.3f, this.field_70165_t - entityIn.field_70165_t, this.field_70161_v - entityIn.field_70161_v);
        }
        return flag;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(RIDING, (Object)false);
        this.field_70180_af.func_187214_a(AGE, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(INTERACTED, (Object)false);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("IsTamed", this.func_70909_n());
        compound.func_74757_a("IsSitting", this.func_70906_o());
        compound.func_74757_a("Riding", this.isFerretRiding());
        GenericBehavior.writeCommonNBT(compound, this);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setFerretRiding(compound.func_74767_n("Riding"));
        GenericBehavior.readCommonNBT(compound, this);
    }

    @Override
    public DataParameter<Integer> getAgeParam() {
        return AGE;
    }

    @Override
    public DataParameter<Boolean> getSleepingParam() {
        return SLEEPING;
    }

    @Override
    public DataParameter<Float> getSleepTimerParam() {
        return SLEEPTIMER;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return GenericBehavior.getAmbientSound(this, ModSoundEvents.ferretLiving1, ModSoundEvents.ferretLiving2, ModSoundEvents.ferretLiving3, ModSoundEvents.ferretLiving4, ModSoundEvents.ferretLiving5, ModSoundEvents.ferretLiving6);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSoundEvents.ferretHurt1;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.ferretHurt1;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null && !this.getSleeping()) {
            this.func_184185_a(soundevent, this.func_70599_aP() - 0.3f, this.func_70647_i());
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.02f, 1.5f);
    }

    private boolean interactRide(EntityPlayer entityplayer) {
        this.isRemoteMountEntity((Entity)entityplayer);
        return true;
    }

    private void isRemoteMountEntity(Entity par1Entity) {
        if (this.isFerretRiding()) {
            this.setFerretRiding(true);
            this.func_184220_m(par1Entity);
        } else if (!this.isFerretRiding()) {
            this.func_184210_p();
        }
    }

    public void func_70636_d() {
        GenericBehavior.livingUpdateCommon(this);
        if (this.func_70906_o() || this.func_184218_aH()) {
            if (this.func_184187_bx() != null) {
                this.field_70177_z = this.func_184187_bx().field_70177_z;
            }
            this.field_70699_by.func_75499_g();
            this.field_70699_by.func_75489_a(0.0);
        }
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
            }
        }
        if (this.tamedTimer > -1) {
            --this.tamedTimer;
            if (this.tamedTimer == 0) {
                this.tamedTimer = 120;
                if (this.func_70909_n() && AnimaniaConfig.gameRules.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                }
            }
        }
        super.func_70636_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean isFerretRiding() {
        return this.getBoolFromDataManager(RIDING);
    }

    public void setFerretRiding(boolean flag) {
        if (flag) {
            this.field_70180_af.func_187227_b(RIDING, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(RIDING, (Object)false);
        }
    }

    @Override
    public DataParameter<Boolean> getFedParam() {
        return FED;
    }

    @Override
    public DataParameter<Boolean> getWateredParam() {
        return WATERED;
    }

    public EntityFerretBase createChild(EntityAgeable ageable) {
        return null;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != ItemStack.field_190927_a && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    @Override
    public Item getSpawnEgg() {
        return ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(this.type, EntityGender.NONE));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getSpawnEgg());
    }

    @Override
    public int getPrimaryEggColor() {
        return 0;
    }

    @Override
    public int getSecondaryEggColor() {
        return 0;
    }

    @Override
    public EntityGender getEntityGender() {
        return EntityGender.NONE;
    }

    @Override
    public Set<Item> getFoodItems() {
        return TEMPTATION_ITEMS;
    }

    @Override
    public void setSleepingPos(BlockPos pos) {
    }

    @Override
    public BlockPos getSleepingPos() {
        return null;
    }

    @Override
    public int getBlinkTimer() {
        return this.blinkTimer;
    }

    @Override
    public void setBlinkTimer(int i) {
        this.blinkTimer = i;
    }

    @Override
    public int getEatTimer() {
        return this.eatTimer;
    }

    @Override
    public void setEatTimer(int i) {
        this.eatTimer = i;
    }

    @Override
    public int getFedTimer() {
        return this.fedTimer;
    }

    @Override
    public void setFedTimer(int i) {
        this.fedTimer = i;
    }

    @Override
    public DataParameter<Boolean> getInteractedParam() {
        return INTERACTED;
    }

    @Override
    public int getWaterTimer() {
        return this.wateredTimer;
    }

    @Override
    public void setWaterTimer(int i) {
        this.wateredTimer = i;
    }

    @Override
    public int getDamageTimer() {
        return this.damageTimer;
    }

    @Override
    public void setDamageTimer(int i) {
        this.damageTimer = i;
    }

    @Override
    public int getHappyTimer() {
        return this.happyTimer;
    }

    @Override
    public void setHappyTimer(int i) {
        this.happyTimer = i;
    }

    @Override
    public AnimaniaType getAnimalType() {
        return this.type;
    }

    @Override
    public DataParameter<Boolean> getHandFedParam() {
        return null;
    }
}

