/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.items;

import com.animania.Animania;
import com.animania.api.data.AnimalContainer;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.AnimaniaType;
import com.animania.api.interfaces.IFoodEating;
import com.animania.common.ModSoundEvents;
import com.animania.common.entities.RandomAnimalType;
import com.animania.common.handler.ItemHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemEntityEgg
extends Item {
    private String name = "entity_egg";
    public AnimaniaType type;
    public EntityGender gender;
    public static Map<AnimalContainer, Item> ANIMAL_EGGS = new HashMap<AnimalContainer, Item>();
    public static Map<AnimalContainer, Integer> ANIMAL_COLOR_PRIMARY = new HashMap<AnimalContainer, Integer>();
    public static Map<AnimalContainer, Integer> ANIMAL_COLOR_SECONDARY = new HashMap<AnimalContainer, Integer>();
    public static Map<AnimalContainer, Boolean> ANIMAL_USES_COLOR = new HashMap<AnimalContainer, Boolean>();

    public ItemEntityEgg(String atype, AnimaniaType animal, EntityGender gender) {
        this.func_77637_a(Animania.TabAnimaniaEggs);
        this.field_77777_bU = 64;
        this.name = this.name + "_" + atype;
        this.setRegistryName(new ResourceLocation("animania", this.name));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
        this.func_77655_b("animania_" + this.name);
        this.type = animal;
        this.gender = gender;
        ANIMAL_EGGS.put(new AnimalContainer(animal, gender), this);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        pos = pos.func_177972_a(facing);
        ItemStack stack = playerIn.func_184586_b(hand);
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        EntityLivingBase entity = null;
        if (this.gender == EntityGender.RANDOM) {
            Class<?> clazz = this.type.getClass();
            AnimaniaType[] types = (AnimaniaType[])clazz.getEnumConstants();
            entity = this.type instanceof RandomAnimalType ? EntityGender.getEntity(this.type, this.gender, world) : EntityGender.getEntity(types[Animania.RANDOM.nextInt(types.length)], this.gender, world);
        } else {
            entity = EntityGender.getEntity(this.type, this.gender, world);
        }
        if (entity != null) {
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            if (stack.func_82837_s()) {
                entity.func_96094_a(stack.func_82833_r());
            }
            if (!playerIn.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            world.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, ModSoundEvents.combo, SoundCategory.PLAYERS, 0.8f, ((Animania.RANDOM.nextFloat() - Animania.RANDOM.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            entity.field_70759_as = entity.field_70177_z;
            entity.field_70761_aq = entity.field_70177_z;
            if (entity instanceof IFoodEating) {
                IFoodEating foodEating = (IFoodEating)entity;
                foodEating.setInteracted(true);
            }
            world.func_72838_d((Entity)entity);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public AnimalContainer getAnimal() {
        return new AnimalContainer(this.type, this.gender);
    }

    public String getName() {
        return this.name;
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)("entity.animania:" + stack.func_77973_b().getRegistryName().func_110623_a().replace("entity_egg_", "") + ".name"));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"item.animania_entity_egg.desc1") + " " + TextFormatting.DARK_GRAY + I18n.func_74838_a((String)"item.animania_entity_egg.desc2"));
    }

    @SideOnly(value=Side.CLIENT)
    public static class Color
    implements IItemColor {
        public int func_186726_a(ItemStack stack, int tintIndex) {
            AnimalContainer animal;
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (!stack.func_190926_b() && stack.func_77973_b() != ItemHandler.entityeggrandomanimal && (animal = ((ItemEntityEgg)stack.func_77973_b()).getAnimal()).getGender() != EntityGender.RANDOM && ANIMAL_USES_COLOR.containsKey(animal) && ANIMAL_USES_COLOR.get(animal).booleanValue()) {
                switch (tintIndex) {
                    case 0: {
                        return ANIMAL_COLOR_PRIMARY.get(animal);
                    }
                    case 1: {
                        return ANIMAL_COLOR_SECONDARY.get(animal);
                    }
                }
            }
            return -1;
        }
    }
}

