/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontRasterizer;
import bre.smoothfont.FontRendererHook;
import bre.smoothfont.FontTextureManager;
import bre.smoothfont.FontUtils;
import bre.smoothfont.GlyphImage;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.util.GLUtils;
import bre.smoothfont.util.Logger;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class FontTexture
extends AbstractTexture {
    public int fontRes;
    public float actualFontRes;
    public float chImageSizePx;
    public float borderWidthPx;
    public int blankSpacePx;
    public int texSizePx;
    public int texFilterSetting;
    public boolean anisotropicFilterSetting;
    public int textureWidth;
    public int textureSize;
    public boolean needReload;
    public float scaleFactor;
    protected final ResourceLocation textureLocation;
    protected final int page;

    public FontTexture(ResourceLocation resourceLoc) {
        this.textureLocation = resourceLoc;
        if ("smoothfont".equals(resourceLoc.func_110624_b())) {
            if (resourceLoc.func_110623_a().equals("osFontDefaultPage".toLowerCase())) {
                this.page = 256;
            } else if (resourceLoc.func_110623_a().startsWith("osFontUnicodePage_".toLowerCase())) {
                String hex = "0x" + resourceLoc.func_110623_a().substring("osFontUnicodePage_".length());
                this.page = Integer.decode(hex);
            } else {
                this.page = -1;
            }
        } else {
            this.page = -1;
        }
        this.fontRes = 0;
        this.chImageSizePx = 0.0f;
        this.borderWidthPx = 0.0f;
        this.blankSpacePx = 0;
        this.texSizePx = 0;
        this.texFilterSetting = 0;
        this.anisotropicFilterSetting = false;
        this.needReload = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_110551_a(IResourceManager iResMgr) throws IOException {
        this.texFilterSetting = 0;
        this.anisotropicFilterSetting = false;
        this.func_147631_c();
        IResource iresource = null;
        try {
            BufferedImage borderedImage;
            boolean flagBlur = false;
            boolean flagClamp = false;
            if ("smoothfont".equals(this.textureLocation.func_110624_b())) {
                GlyphImage glyphCache = FontRasterizer.getInstance().getGlyphImage(this.page);
                assert (glyphCache != null) : "glyphImage-" + this.page + " is null";
                borderedImage = glyphCache.getGlyphImage();
                if (FontRendererHook.extShaderWorking && borderedImage.getType() == 10) {
                    borderedImage = FontUtils.convertDataBufferGrayToABGR(borderedImage);
                }
                this.fontRes = FontTextureManager.getInstance().getUnicodeFontRes(true);
                this.borderWidthPx = glyphCache.borderSize;
                this.chImageSizePx = glyphCache.chImageBoxSize;
            } else {
                iresource = iResMgr.func_110536_a(this.textureLocation);
                BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
                borderedImage = this.addTextureBorder(bufferedimage);
                if (iresource.func_110528_c()) {
                    try {
                        TextureMetadataSection texturemetadatasection = (TextureMetadataSection)iresource.func_110526_a("texture");
                        if (texturemetadatasection != null) {
                            flagBlur = texturemetadatasection.func_110479_a();
                            flagClamp = texturemetadatasection.func_110480_b();
                        }
                    }
                    catch (RuntimeException runtimeexception) {
                        Logger.warn("Failed reading metadata of: " + this.textureLocation);
                    }
                }
            }
            this.scaleFactor = 1.0f;
            this.actualFontRes = this.fontRes;
            if (this.fontRes <= CommonConfig.currentConfig.blurReduction) {
                this.scaleFactor = 2.0f;
                borderedImage = FontUtils.resizeImage(borderedImage, this.scaleFactor, false);
                this.actualFontRes = (float)this.fontRes * this.scaleFactor;
            }
            if (CommonConfig.currentConfig.saveMemory >= 1 && this.fontRes >= 256 || CommonConfig.currentConfig.saveMemory >= 2 && this.fontRes >= 128) {
                this.scaleFactor = (float)(this.fontRes * 16) / (float)borderedImage.getWidth();
                borderedImage = FontUtils.resizeImage(borderedImage, this.scaleFactor, true);
                this.actualFontRes = (float)this.fontRes * this.scaleFactor;
            }
            this.blankSpacePx = 0;
            if (!CommonConfig.currentConfig.allowNPOTTexture && !FontUtils.isPOT(borderedImage.getWidth())) {
                int width = borderedImage.getWidth();
                int potWidth = FontUtils.nearPOT(width);
                this.blankSpacePx = potWidth - width;
                borderedImage = FontUtils.expandFrame(borderedImage, potWidth, potWidth);
            }
            this.texSizePx = borderedImage.getWidth();
            if (this.scaleFactor != 1.0f) {
                this.chImageSizePx *= this.scaleFactor;
                this.borderWidthPx *= this.scaleFactor;
            }
            this.textureWidth = borderedImage.getWidth();
            this.textureSize = FontUtils.getImageSize(borderedImage);
            if (CommonConfig.currentConfig.enableMipmap) {
                this.textureSize += this.textureSize / 3;
            }
            this.uploadTextureImageAllocate(this.func_110552_b(), borderedImage, flagBlur, flagClamp);
            this.needReload = false;
            Logger.debug("Loaded page-", this.page, " texture ", borderedImage.getWidth(), "x", borderedImage.getHeight());
            if (iresource == null) return;
        }
        catch (Throwable throwable) {
            if (iresource == null) throw throwable;
            IOUtils.closeQuietly(iresource);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)iresource);
    }

    private void uploadTextureImageAllocate(int textureId, BufferedImage texture, boolean blur, boolean clamp) {
        int mipmapLevel;
        int n = mipmapLevel = CommonConfig.currentConfig.enableMipmap ? CommonConfig.currentConfig.mipmapLevel : 0;
        if (texture.getType() == 10) {
            GLUtils.allocateTexture(textureId, mipmapLevel, texture.getWidth(), texture.getHeight(), true);
        } else {
            TextureUtil.func_180600_a((int)textureId, (int)mipmapLevel, (int)texture.getWidth(), (int)texture.getHeight());
        }
        if (CommonConfig.currentConfig.enableMipmap && !GLUtils.glGenerateMipmapSupported) {
            GL11.glTexParameteri((int)3553, (int)33085, (int)CommonConfig.currentConfig.mipmapLevel);
            GL11.glTexParameteri((int)3553, (int)33169, (int)1);
        }
        if (texture.getType() == 10) {
            GLUtils.uploadTextureImage(textureId, texture, 0, 0, blur, clamp);
        } else {
            TextureUtil.func_110995_a((int)textureId, (BufferedImage)texture, (int)0, (int)0, (boolean)blur, (boolean)clamp);
        }
        if (CommonConfig.currentConfig.enableMipmap && GLUtils.glGenerateMipmapSupported) {
            GL30.glGenerateMipmap((int)3553);
        }
    }

    protected BufferedImage addTextureBorder(BufferedImage origImg) {
        int width = origImg.getWidth();
        int height = origImg.getHeight();
        this.fontRes = width / 16;
        this.borderWidthPx = FontUtils.getBorderWidth(this.fontRes, false);
        int borderWidthInt = (int)this.borderWidthPx;
        int glyphGap = borderWidthInt * 2;
        this.chImageSizePx = this.fontRes;
        int textureSize = (this.fontRes + borderWidthInt * 2) * 16;
        BufferedImage newImg = new BufferedImage(textureSize, textureSize, 6);
        Graphics2D g2 = newImg.createGraphics();
        FontUtils.clearGraphics2D(g2, 0, 0, newImg.getWidth(), newImg.getHeight());
        if (origImg.getType() == 12) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int alpha = origImg.getRGB(x, y) >>> 24;
                    if (alpha != 255) continue;
                    newImg.setRGB(x + x / this.fontRes * glyphGap + borderWidthInt, y + y / this.fontRes * glyphGap + borderWidthInt, -1);
                }
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    BufferedImage charImage = origImg.getSubimage(i * this.fontRes, j * this.fontRes, this.fontRes, this.fontRes);
                    g2.drawImage((Image)charImage, i * (this.fontRes + glyphGap) + borderWidthInt, j * (this.fontRes + glyphGap) + borderWidthInt, null);
                }
            }
        }
        g2.dispose();
        return newImg;
    }

    private int[][] generateMipmapData(BufferedImage texture, int level) {
        int width = texture.getWidth();
        int height = texture.getHeight();
        int[] aint = new int[width * height];
        Object mipmap = new int[level + 1][];
        texture.getRGB(0, 0, width, height, aint, 0, width);
        mipmap[0] = aint;
        mipmap = TextureUtil.func_147949_a((int)level, (int)width, (int[][])mipmap);
        return mipmap;
    }

    public int page() {
        return this.page;
    }
}

