package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;

public class MM_Sticky extends MobModifier
{
    
    public MM_Sticky()
    {
        super();
    }
    
    public MM_Sticky(MobModifier next)
    {
        super(next);
    }

    @Override
    public String getModName()
    {
        return "Sticky";
    }
    
    private long nextAbilityUse = 0L;
    private final static long coolDown = 15000L;
    
    @Override
    public float onHurt(EntityLivingBase mob, DamageSource source, float damage)
    {
        if (source.func_76346_g() != null
        && (source.func_76346_g() instanceof EntityPlayer))
        {
            EntityPlayer p = (EntityPlayer)source.func_76346_g();
            ItemStack weapon = p.field_71071_by.func_70301_a(p.field_71071_by.field_70461_c);
            if (weapon != null)
            {
                long time = System.currentTimeMillis();
                if (time > nextAbilityUse
                && source.func_76346_g() != null
                && !(source instanceof EntityDamageSourceIndirect))
                {
                    nextAbilityUse = time+coolDown;
                    EntityItem drop = p.func_71019_a(p.field_71071_by.func_70298_a(p.field_71071_by.field_70461_c, 1), false);
                    if (drop != null)
                    {
                        drop.func_174867_a(50);
                        mob.field_70170_p.func_184133_a(null, new BlockPos(mob), SoundEvents.field_187870_fk, SoundCategory.HOSTILE, 1.0F + mob.func_70681_au().nextFloat(), mob.func_70681_au().nextFloat() * 0.7F + 0.3F);
                    }
                }
            }
        }
        
        return super.onHurt(mob, source, damage);
    }
    
    private Class<?>[] disallowed = { EntityCreeper.class };
    
    @Override
    public Class<?>[] getBlackListMobClasses()
    {
        return disallowed;
    }
    
    @Override
    protected String[] getModNameSuffix()
    {
        return suffix;
    }
    private static String[] suffix = { "ofSnagging", "theQuickFingered", "ofPettyTheft", "yoink" };
    
    @Override
    protected String[] getModNamePrefix()
    {
        return prefix;
    }
    private static String[] prefix = { "thieving", "snagging", "quickfingered" };
    
}
