package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;

public class MM_Weakness extends MobModifier
{
    
    public MM_Weakness()
    {
        super();
    }
    
    public MM_Weakness(MobModifier next)
    {
        super(next);
    }

    @Override
    public String getModName()
    {
        return "Weakness";
    }
    
    @Override
    public float onHurt(EntityLivingBase mob, DamageSource source, float damage)
    {
        if (source.func_76346_g() != null
        && (source.func_76346_g() instanceof EntityLivingBase)
        && InfernalMobsCore.instance().getIsEntityAllowedTarget(source.func_76346_g()))
        {
            ((EntityLivingBase)source.func_76346_g()).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 120, 0));
        }
        
        return super.onHurt(mob, source, damage);
    }
    
    @Override
    public float onAttack(EntityLivingBase entity, DamageSource source, float damage)
    {
        if (entity != null
        && InfernalMobsCore.instance().getIsEntityAllowedTarget(entity))
        {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 120, 0));
        }
        
        return super.onAttack(entity, source, damage);
    }
    
    @Override
    protected String[] getModNameSuffix()
    {
        return suffix;
    }
    private static String[] suffix = { "ofApathy", "theDeceiver" };
    
    @Override
    protected String[] getModNamePrefix()
    {
        return prefix;
    }
    private static String[] prefix = { "apathetic", "deceiving" };
}
