package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class MM_Webber extends MobModifier
{
    
    public MM_Webber()
    {
        super();
    }
    
    public MM_Webber(MobModifier next)
    {
        super(next);
    }

    @Override
    public String getModName()
    {
        return "Webber";
    }
    
    private long lastAbilityUse = 0L;
    private final static long coolDown = 15000L;
    
    @Override
    public boolean onUpdate(EntityLivingBase mob)
    {
        if (hasSteadyTarget()
        && getMobTarget() instanceof EntityPlayer)
        {
            tryAbility(mob, getMobTarget());
        }
        
        return super.onUpdate(mob);
    }
    
    @Override
    public float onHurt(EntityLivingBase mob, DamageSource source, float damage)
    {
        if (source.func_76346_g() != null
        && source.func_76346_g() instanceof EntityLivingBase)
        {
            tryAbility(mob, (EntityLivingBase) source.func_76346_g());
        }
        
        return super.onHurt(mob, source, damage);
    }

    private void tryAbility(EntityLivingBase mob, EntityLivingBase target)
    {
        if (target == null || !mob.func_70685_l(target))
        {
            return;
        }
        
        int x = MathHelper.func_76128_c(target.field_70165_t);
        int y = MathHelper.func_76128_c(target.field_70163_u);
        int z = MathHelper.func_76128_c(target.field_70161_v);
        
        long time = System.currentTimeMillis();
        if (time > lastAbilityUse+coolDown)
        {
            int offset;
            if (target.field_70170_p.func_180495_p(new BlockPos(x, y-1, z)).func_177230_c() == Blocks.field_150350_a)
            {
                offset = -1;
            }
            else if (target.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_150350_a)
            {
                offset = 0;
            }
            else
            {
                return;
            }
            
            lastAbilityUse = time;
            target.field_70170_p.func_175656_a(new BlockPos(x,  y+offset,  z),  Blocks.field_150321_G.func_176223_P());
            mob.field_70170_p.func_184133_a(null, new BlockPos(mob), SoundEvents.field_187817_fK, SoundCategory.HOSTILE, 1.0F + mob.func_70681_au().nextFloat(), mob.func_70681_au().nextFloat() * 0.7F + 0.3F);
        }
    }
    
    @Override
    public Class<?>[] getModsNotToMixWith()
    {
        return modBans;
    }
    private static Class<?>[] modBans = { MM_Gravity.class, MM_Blastoff.class };
    
    @Override
    protected String[] getModNameSuffix()
    {
        return suffix;
    }
    private static String[] suffix = { "ofTraps", "theMutated", "theSpider" };
    
    @Override
    protected String[] getModNamePrefix()
    {
        return prefix;
    }
    private static String[] prefix = { "ensnaring", "webbing" };
    
}
